/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Graphs.LineGraph;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Modules.OverRepresentedSeqs;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class DuplicationLevel
extends AbstractQCModule {
    private OverRepresentedSeqs overrepresentedModule;
    private double[] deduplicatedPercentages = null;
    private double[] totalPercentages = null;
    private double maxCount = 100.0;
    private double percentDifferentSeqs = 0.0;
    private String[] labels;
    private static final DecimalFormat df = new DecimalFormat("#.##");

    protected DuplicationLevel(OverRepresentedSeqs overrepresentedModule) {
        this.overrepresentedModule = overrepresentedModule;
    }

    public String description() {
        return "Plots the number of sequences which are duplicated to different levels";
    }

    public boolean ignoreFilteredSequences() {
        return ModuleConfig.getParam("duplication", "ignore") > 0.0;
    }

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("duplication", "ignore") > 0.0;
    }

    protected synchronized void calculateLevels() {
        if (this.deduplicatedPercentages != null) {
            return;
        }
        this.deduplicatedPercentages = new double[16];
        this.totalPercentages = new double[16];
        HashMap<Integer, Integer> collatedCounts = new HashMap<Integer, Integer>();
        Iterator<String> it = this.overrepresentedModule.sequences.keySet().iterator();
        while (it.hasNext()) {
            int thisCount = this.overrepresentedModule.sequences.get(it.next());
            if (collatedCounts.containsKey(thisCount)) {
                collatedCounts.put(thisCount, (Integer)collatedCounts.get(thisCount) + 1);
                continue;
            }
            collatedCounts.put(thisCount, 1);
        }
        HashMap<Integer, Double> correctedCounts = new HashMap<Integer, Double>();
        Iterator itr = collatedCounts.keySet().iterator();
        while (itr.hasNext()) {
            int dupLevel = (Integer)itr.next();
            int count = (Integer)collatedCounts.get(dupLevel);
            correctedCounts.put(dupLevel, DuplicationLevel.getCorrectedCount(this.overrepresentedModule.countAtUniqueLimit, this.overrepresentedModule.count, dupLevel, count));
        }
        double dedupTotal = 0.0;
        double rawTotal = 0.0;
        Iterator itc = correctedCounts.keySet().iterator();
        while (itc.hasNext()) {
            int dupLevel = (Integer)itc.next();
            double count = (Double)correctedCounts.get(dupLevel);
            dedupTotal += count;
            rawTotal += count * (double)dupLevel;
            int dupSlot = dupLevel - 1;
            if (dupSlot > 9999) {
                dupSlot = 15;
            } else if (dupSlot > 4999) {
                dupSlot = 14;
            } else if (dupSlot > 999) {
                dupSlot = 13;
            } else if (dupSlot > 499) {
                dupSlot = 12;
            } else if (dupSlot > 99) {
                dupSlot = 11;
            } else if (dupSlot > 49) {
                dupSlot = 10;
            } else if (dupSlot > 9) {
                dupSlot = 9;
            }
            int n = dupSlot;
            this.deduplicatedPercentages[n] = this.deduplicatedPercentages[n] + count;
            int n2 = dupSlot;
            this.totalPercentages[n2] = this.totalPercentages[n2] + count * (double)dupLevel;
        }
        this.labels = new String[16];
        int i = 0;
        while (i < this.deduplicatedPercentages.length) {
            if (i < 9) {
                this.labels[i] = "" + (i + 1);
            } else if (i == 9) {
                this.labels[i] = ">10";
            } else if (i == 10) {
                this.labels[i] = ">50";
            } else if (i == 11) {
                this.labels[i] = ">100";
            } else if (i == 12) {
                this.labels[i] = ">500";
            } else if (i == 13) {
                this.labels[i] = ">1k";
            } else if (i == 14) {
                this.labels[i] = ">5k";
            } else if (i == 15) {
                this.labels[i] = ">10k";
            }
            int n = i;
            this.deduplicatedPercentages[n] = this.deduplicatedPercentages[n] / dedupTotal;
            int n3 = i;
            this.totalPercentages[n3] = this.totalPercentages[n3] / rawTotal;
            int n4 = i;
            this.deduplicatedPercentages[n4] = this.deduplicatedPercentages[n4] * 100.0;
            int n5 = i++;
            this.totalPercentages[n5] = this.totalPercentages[n5] * 100.0;
        }
        this.percentDifferentSeqs = dedupTotal / rawTotal * 100.0;
    }

    private static double getCorrectedCount(long countAtLimit, long totalCount, int duplicationLevel, int numberOfObservations) {
        if (countAtLimit == totalCount) {
            return numberOfObservations;
        }
        if (totalCount - (long)numberOfObservations < countAtLimit) {
            return numberOfObservations;
        }
        double pNotSeeingAtLimit = 1.0;
        int i = 0;
        while ((long)i < countAtLimit) {
            pNotSeeingAtLimit *= (double)(totalCount - (long)i - (long)duplicationLevel) / (double)(totalCount - (long)i);
            ++i;
        }
        double pSeeingAtLimit = 1.0 - pNotSeeingAtLimit;
        double trueCount = (double)numberOfObservations / pSeeingAtLimit;
        return trueCount;
    }

    public JPanel getResultsPanel() {
        if (this.deduplicatedPercentages == null) {
            this.calculateLevels();
        }
        return new LineGraph((double[][])new double[][]{this.deduplicatedPercentages, this.totalPercentages}, 0.0, this.maxCount, "Sequence Duplication Level", new String[]{"% Deduplicated sequences", "% Total sequences"}, this.labels, "Percent of seqs remaining if deduplicated " + df.format(this.percentDifferentSeqs) + "%");
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        if (this.deduplicatedPercentages == null) {
            this.calculateLevels();
        }
        ZipOutputStream zip = report.zipFile();
        zip.putNextEntry(new ZipEntry(String.valueOf(report.folderName()) + "/Images/duplication_levels.png"));
        BufferedImage b = new BufferedImage(800, 600, 1);
        Graphics g = b.getGraphics();
        LineGraph lg = new LineGraph((double[][])new double[][]{this.deduplicatedPercentages, this.totalPercentages}, 0.0, this.maxCount, "Sequence Duplication Level", new String[]{"% Deduplicated sequences", "% Total sequences"}, this.labels, "Percent of seqs remaining if deduplicated " + df.format(this.percentDifferentSeqs) + "%");
        lg.paint(g, 800, 600);
        ImageIO.write((RenderedImage)b, "PNG", zip);
        zip.closeEntry();
        super.simpleXhtmlReport(report, b, "Duplication level graph");
        StringBuffer sb = report.dataDocument();
        sb.append("#Total Deduplicated Percentage\t");
        sb.append(this.percentDifferentSeqs);
        sb.append("\n");
        sb.append("#Duplication Level\tPercentage of deduplicated\tPercentage of total\n");
        int i = 0;
        while (i < this.labels.length) {
            sb.append(this.labels[i]);
            if (i == this.labels.length - 1) {
                sb.append("+");
            }
            sb.append("\t");
            sb.append(this.deduplicatedPercentages[i]);
            sb.append("\t");
            sb.append(this.totalPercentages[i]);
            sb.append("\n");
            ++i;
        }
    }

    public String name() {
        return "Sequence Duplication Levels";
    }

    public void processSequence(Sequence sequence) {
    }

    public boolean raisesError() {
        if (this.deduplicatedPercentages == null) {
            this.calculateLevels();
        }
        return this.percentDifferentSeqs < ModuleConfig.getParam("duplication", "error");
    }

    public boolean raisesWarning() {
        if (this.deduplicatedPercentages == null) {
            this.calculateLevels();
        }
        return this.percentDifferentSeqs < ModuleConfig.getParam("duplication", "warn");
    }

    public void reset() {
        this.deduplicatedPercentages = null;
    }
}

