/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules.GCModel;

import uk.ac.babraham.FastQC.Modules.GCModel.GCModelValue;

public class GCModel {
    public int readLength;
    public GCModelValue[][] models;

    public GCModel(int readLength) {
        int highPercentage;
        int lowPercentage;
        double highCount;
        double lowCount;
        int[] claimingCounts = new int[101];
        this.readLength = readLength;
        this.models = new GCModelValue[readLength + 1][];
        int pos = 0;
        while (pos <= readLength) {
            lowCount = (double)pos - 0.5;
            highCount = (double)pos + 0.5;
            if (lowCount < 0.0) {
                lowCount = 0.0;
            }
            if (highCount < 0.0) {
                highCount = 0.0;
            }
            if (highCount > (double)readLength) {
                highCount = readLength;
            }
            if (lowCount > (double)readLength) {
                lowCount = readLength;
            }
            lowPercentage = (int)Math.round(lowCount * 100.0 / (double)readLength);
            highPercentage = (int)Math.round(highCount * 100.0 / (double)readLength);
            int p = lowPercentage;
            while (p <= highPercentage) {
                int n = p++;
                claimingCounts[n] = claimingCounts[n] + 1;
            }
            ++pos;
        }
        pos = 0;
        while (pos <= readLength) {
            lowCount = (double)pos - 0.5;
            highCount = (double)pos + 0.5;
            if (lowCount < 0.0) {
                lowCount = 0.0;
            }
            if (highCount < 0.0) {
                highCount = 0.0;
            }
            if (highCount > (double)readLength) {
                highCount = readLength;
            }
            if (lowCount > (double)readLength) {
                lowCount = readLength;
            }
            lowPercentage = (int)Math.round(lowCount * 100.0 / (double)readLength);
            highPercentage = (int)Math.round(highCount * 100.0 / (double)readLength);
            GCModelValue[] modelValues = new GCModelValue[highPercentage - lowPercentage + 1];
            int p = lowPercentage;
            while (p <= highPercentage) {
                modelValues[p - lowPercentage] = new GCModelValue(p, 1.0 / (double)claimingCounts[p]);
                ++p;
            }
            this.models[pos] = modelValues;
            ++pos;
        }
    }

    public GCModelValue[] getModelValues(int gcCount) {
        return this.models[gcCount];
    }
}

