/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Sequence.Contaminant.ContaminentFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleConfig {
    private static HashMap<String, Double> parameters = ModuleConfig.readParams();

    private static HashMap<String, Double> readParams() {
        HashMap<String, Double> params = new HashMap<String, Double>();
        params.put("duplication:warn", 70.0);
        params.put("duplication:error", 50.0);
        params.put("kmer:warn", 2.0);
        params.put("kmer:error", 5.0);
        params.put("n_content:warn", 5.0);
        params.put("n_content:error", 20.0);
        params.put("overrepresented:warn", 0.1);
        params.put("overrepresented:error", 1.0);
        params.put("quality_base_lower:warn", 10.0);
        params.put("quality_base_lower:error", 5.0);
        params.put("quality_base_median:warn", 25.0);
        params.put("quality_base_median:error", 20.0);
        params.put("sequence:warn", 10.0);
        params.put("sequence:error", 20.0);
        params.put("gc_sequence:warn", 15.0);
        params.put("gc_sequence:error", 30.0);
        params.put("quality_sequence:warn", 20.0);
        params.put("quality_sequence:error", 27.0);
        params.put("tile:warn", 5.0);
        params.put("tile:error", 10.0);
        params.put("sequence_length:warn", 1.0);
        params.put("sequence_length:error", 1.0);
        params.put("adapter:warn", 5.0);
        params.put("adapter:error", 10.0);
        params.put("duplication:ignore", 0.0);
        params.put("kmer:ignore", 0.0);
        params.put("n_content:ignore", 0.0);
        params.put("overrepresented:ignore", 0.0);
        params.put("quality_base:ignore", 0.0);
        params.put("sequence:ignore", 0.0);
        params.put("gc_quality:ignore", 0.0);
        params.put("quality_sequence:ignore", 0.0);
        params.put("tile:ignore", 0.0);
        params.put("sequence_length:ignore", 0.0);
        params.put("adapter:ignore", 0.0);
        try {
            String line;
            BufferedReader br;
            if (FastQCConfig.getInstance().limits_file == null) {
                InputStream rsrc = ContaminentFinder.class.getResourceAsStream("/Configuration/limits.txt");
                if (rsrc == null) {
                    throw new FileNotFoundException("cannot find Configuration/limits.txt");
                }
                br = new BufferedReader(new InputStreamReader(rsrc));
            } else {
                br = new BufferedReader(new FileReader(FastQCConfig.getInstance().limits_file));
            }
            while ((line = br.readLine()) != null) {
                double value;
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                String[] sections = line.split("\\s+");
                if (sections.length != 3) {
                    System.err.println("Config line '" + line + "' didn't contain the 3 required sections");
                }
                if (!(sections[1].equals("warn") || sections[1].equals("error") || sections[1].equals("ignore"))) {
                    System.err.println("Second config field must be error, warn or ignore, not '" + sections[1] + "'");
                    continue;
                }
                try {
                    value = Double.parseDouble(sections[2]);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Value " + sections[2] + " didn't look like a number");
                    continue;
                }
                String key = String.valueOf(sections[0]) + ":" + sections[1];
                params.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static Double getParam(String module, String level) {
        if (!(level.equals("warn") || level.equals("error") || level.equals("ignore"))) {
            throw new IllegalArgumentException("Level must be warn, error or ignore");
        }
        String key = String.valueOf(module) + ":" + level;
        if (!parameters.containsKey(key)) {
            throw new IllegalArgumentException("No key called " + key + " in the config data");
        }
        return parameters.get(key);
    }
}

