/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Sequence.QualityEncoding;

public class PhredEncoding {
    private String name;
    private int offset;
    private static final int SANGER_ENCODING_OFFSET = 33;
    private static final int ILLUMINA_1_3_ENCODING_OFFSET = 64;

    public static PhredEncoding getFastQEncodingOffset(char lowestChar) {
        if (lowestChar < '!') {
            throw new IllegalArgumentException("No known encodings with chars < 33 (Yours was " + lowestChar + ")");
        }
        if (lowestChar < '@') {
            return new PhredEncoding("Sanger / Illumina 1.9", 33);
        }
        if (lowestChar == 'A') {
            return new PhredEncoding("Illumina 1.3", 64);
        }
        if (lowestChar <= '~') {
            return new PhredEncoding("Illumina 1.5", 64);
        }
        throw new IllegalArgumentException("No known encodings with chars > 126 (Yours was " + lowestChar + ")");
    }

    public static double convertSangerPhredToProbability(int phred) {
        return Math.pow(10.0, (double)phred / -10.0);
    }

    public static double convertOldIlluminaPhredToProbability(int phred) {
        return Math.pow(10.0, (double)phred / (double)(phred + 1) / -10.0);
    }

    public static int convertProbabilityToSangerPhred(double p) {
        return (int)Math.round(-10.0 * Math.log10(p));
    }

    public static int convertProbabilityToOldIlluminaPhred(double p) {
        return (int)Math.round(-10.0 * Math.log10(p / 1.0 - p));
    }

    private PhredEncoding(String name, int offset) {
        this.name = name;
        this.offset = offset;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public int offset() {
        return this.offset;
    }

    public static void main(String[] args) {
        double p = 0.4;
        System.out.println("Sanger phred for p=" + p + " is " + PhredEncoding.convertProbabilityToSangerPhred(p));
        int phred = 4;
        System.out.println("P value for Sanger phred=" + phred + " is " + PhredEncoding.convertSangerPhredToProbability(phred));
    }
}

