/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5ObjectReadOnlyInfoProviderHandler;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5ObjectReadWriteInfoProviderHandler;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;

final class HDF5ObjectReadWriteInfoProviderHandler
extends HDF5ObjectReadOnlyInfoProviderHandler
implements IHDF5ObjectReadWriteInfoProviderHandler {
    private final HDF5BaseWriter baseWriter;

    HDF5ObjectReadWriteInfoProviderHandler(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void createHardLink(String currentPath, String newPath) {
        assert (currentPath != null);
        assert (newPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.h5.createHardLink(this.baseWriter.fileId, currentPath, newPath);
    }

    @Override
    public void createSoftLink(String targetPath, String linkPath) {
        assert (targetPath != null);
        assert (linkPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.h5.createSoftLink(this.baseWriter.fileId, linkPath, targetPath);
    }

    @Override
    public void createOrUpdateSoftLink(String targetPath, String linkPath) {
        assert (targetPath != null);
        assert (linkPath != null);
        this.baseWriter.checkOpen();
        if (this.isSymbolicLink(linkPath)) {
            this.delete(linkPath);
        }
        this.baseWriter.h5.createSoftLink(this.baseWriter.fileId, linkPath, targetPath);
    }

    @Override
    public void createExternalLink(String targetFileName, String targetPath, String linkPath) throws IllegalStateException {
        assert (targetFileName != null);
        assert (targetPath != null);
        assert (linkPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.h5.createExternalLink(this.baseWriter.fileId, linkPath, targetFileName, targetPath);
    }

    @Override
    public void createOrUpdateExternalLink(String targetFileName, String targetPath, String linkPath) throws IllegalStateException {
        assert (targetFileName != null);
        assert (targetPath != null);
        assert (linkPath != null);
        this.baseWriter.checkOpen();
        if (this.isSymbolicLink(linkPath)) {
            this.delete(linkPath);
        }
        this.baseWriter.h5.createExternalLink(this.baseWriter.fileId, linkPath, targetFileName, targetPath);
    }

    @Override
    public void delete(String objectPath) {
        this.baseWriter.checkOpen();
        if (this.isGroup(objectPath, false)) {
            for (String path : this.getGroupMemberPaths(objectPath)) {
                this.delete(path);
            }
        }
        this.baseWriter.h5.deleteObject(this.baseWriter.fileId, objectPath);
    }

    @Override
    public void move(String oldLinkPath, String newLinkPath) {
        this.baseWriter.checkOpen();
        this.baseWriter.h5.moveLink(this.baseWriter.fileId, oldLinkPath, newLinkPath);
    }

    @Override
    public void createGroup(String groupPath) {
        this.baseWriter.checkOpen();
        this.baseWriter.h5.createGroup(this.baseWriter.fileId, groupPath);
    }

    @Override
    public void createGroup(final String groupPath, final int sizeHint) {
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createGroupRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.h5.createOldStyleGroup(((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.fileId, groupPath, sizeHint, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createGroupRunnable);
    }

    @Override
    public void createGroup(final String groupPath, final int maxCompact, final int minDense) {
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createGroupRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.h5.createNewStyleGroup(((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.fileId, groupPath, maxCompact, minDense, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createGroupRunnable);
    }

    @Override
    public void deleteAttribute(final String objectPath, final String name) {
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> deleteAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long objectId = ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.h5.openObject(((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.fileId, objectPath, registry);
                ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.h5.deleteAttribute(objectId, name);
                return null;
            }
        };
        this.baseWriter.runner.call(deleteAttributeRunnable);
    }

    @Override
    public void setDataSetSize(String objectPath, long newSize) {
        this.setDataSetDimensions(objectPath, new long[]{newSize});
    }

    @Override
    public void setDataSetDimensions(final String objectPath, final long[] newDimensions) {
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5ObjectReadWriteInfoProviderHandler.this.baseWriter.setDataSetDimensions(objectPath, newDimensions, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void setTypeVariant(final String objectPath, final HDF5DataTypeVariant typeVariant) {
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    long dataSpaceId = ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.h5.createSimpleDataSpace(new long[]{1L}, registry);
                    HDF5ObjectReadWriteInfoProviderHandler.this.baseWriter.setAttribute(objectPath, HDF5Utils.createObjectTypeVariantAttributeName(((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.houseKeepingNameSuffix), ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getStorageTypeId(), ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getNativeTypeId(), dataSpaceId, ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getEnumType().toStorageForm(typeVariant.ordinal()), registry);
                } else {
                    HDF5ObjectReadWriteInfoProviderHandler.this.baseWriter.setAttribute(objectPath, HDF5Utils.createObjectTypeVariantAttributeName(((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.houseKeepingNameSuffix), ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getStorageTypeId(), ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getNativeTypeId(), -1L, ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getEnumType().toStorageForm(typeVariant.ordinal()), registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setTypeVariant(final String objectPath, final String attributeName, final HDF5DataTypeVariant typeVariant) {
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                if (((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    long dataSpaceId = ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.h5.createSimpleDataSpace(new long[]{1L}, registry);
                    HDF5ObjectReadWriteInfoProviderHandler.this.baseWriter.setAttribute(objectPath, HDF5Utils.createAttributeTypeVariantAttributeName(attributeName, ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.houseKeepingNameSuffix), ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getStorageTypeId(), ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getNativeTypeId(), dataSpaceId, ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getEnumType().toStorageForm(typeVariant.ordinal()), registry);
                } else {
                    HDF5ObjectReadWriteInfoProviderHandler.this.baseWriter.setAttribute(objectPath, HDF5Utils.createAttributeTypeVariantAttributeName(attributeName, ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.houseKeepingNameSuffix), ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getStorageTypeId(), ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getNativeTypeId(), -1L, ((HDF5ObjectReadWriteInfoProviderHandler)HDF5ObjectReadWriteInfoProviderHandler.this).baseWriter.typeVariantDataType.getEnumType().toStorageForm(typeVariant.ordinal()), registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void deleteTypeVariant(String objectPath) {
        this.deleteAttribute(objectPath, HDF5Utils.createObjectTypeVariantAttributeName(this.baseWriter.houseKeepingNameSuffix));
    }

    @Override
    public void deleteTypeVariant(String objectPath, String attributeName) {
        this.deleteAttribute(objectPath, HDF5Utils.createAttributeTypeVariantAttributeName(attributeName, this.baseWriter.houseKeepingNameSuffix));
    }
}

