/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina;

import java.util.Objects;
import org.apache.commons.csv.CSVRecord;

public class CSVUtils {
    public static int parseInt(CSVRecord record, String fieldName, int defaultValue) {
        Objects.requireNonNull(record);
        Objects.requireNonNull(fieldName);
        if (!record.isSet(fieldName)) {
            return defaultValue;
        }
        String value = record.get(fieldName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long parseLong(CSVRecord record, String fieldName, long defaultValue) {
        Objects.requireNonNull(record);
        Objects.requireNonNull(fieldName);
        if (!record.isSet(fieldName)) {
            return defaultValue;
        }
        String value = record.get(fieldName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double parseDouble(CSVRecord record, String fieldName, double defaultValue) {
        Objects.requireNonNull(record);
        Objects.requireNonNull(fieldName);
        if (!record.isSet(fieldName)) {
            return defaultValue;
        }
        String value = record.get(fieldName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String parseString(CSVRecord record, String fieldName, String defaultValue) {
        Objects.requireNonNull(record);
        Objects.requireNonNull(fieldName);
        if (!record.isSet(fieldName)) {
            return defaultValue;
        }
        String value = record.get(fieldName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

