/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public class PrimaryAnalysisMetrics {
    private float averageQ30 = Float.NaN;
    private float totalYield = Float.NaN;
    private float totalReadsPF = Float.NaN;
    private float loadingConcentrationPercent = Float.NaN;

    public float getAverageQ30() {
        return this.averageQ30;
    }

    public float getTotalYield() {
        return this.totalYield;
    }

    public float getTotalReadsPF() {
        return this.totalReadsPF;
    }

    public float getLoadingConcentrationPercent() {
        return this.loadingConcentrationPercent;
    }

    private static float multiplyFactor(String s) {
        if (s == null || s.trim().isEmpty()) {
            return 1.0f;
        }
        switch (s.trim().charAt(0)) {
            case '%': {
                return 0.01f;
            }
            case 'M': {
                return 1000000.0f;
            }
            case 'G': {
                return 1.0E9f;
            }
        }
        return 1.0f;
    }

    public PrimaryAnalysisMetrics(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public PrimaryAnalysisMetrics(InputStream in) throws IOException {
        Objects.requireNonNull(in);
        try (InputStreamReader reader = new InputStreamReader(in);){
            block21: for (CSVRecord record : CSVFormat.RFC4180.builder().setIgnoreEmptyLines(true).setHeader(Headers.class).setSkipHeaderRecord(true).build().parse((Reader)reader)) {
                String metric = record.get((Enum)Headers.Metric).toLowerCase().trim();
                String value = record.get((Enum)Headers.Value).toLowerCase().trim();
                String unit = record.get((Enum)Headers.Unit);
                switch (metric) {
                    case "average %q30": {
                        this.averageQ30 = Float.parseFloat(value) * PrimaryAnalysisMetrics.multiplyFactor(unit);
                        continue block21;
                    }
                    case "total yield": {
                        this.totalYield = Float.parseFloat(value) * PrimaryAnalysisMetrics.multiplyFactor(unit);
                        continue block21;
                    }
                    case "total reads pf": {
                        this.totalReadsPF = Float.parseFloat(value) * PrimaryAnalysisMetrics.multiplyFactor(unit);
                        continue block21;
                    }
                    case "% loading concentration": {
                        this.loadingConcentrationPercent = Float.parseFloat(value) * PrimaryAnalysisMetrics.multiplyFactor(unit);
                        continue block21;
                    }
                }
                throw new IllegalStateException("Unknown metric: " + record.get((Enum)Headers.Metric));
            }
        }
    }

    private static enum Headers {
        Metric,
        Unit,
        Value;

    }
}

