/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.kenetre.KenetreRuntimeException;
import fr.ens.biologie.genomique.kenetre.util.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RunParameters {
    private final String applicationName;
    private final String applicationVersion;
    private final String rtaVersion;
    private final int rtaMajorVersion;
    private final String sequencerFamily;

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getRTAVersion() {
        return this.rtaVersion;
    }

    public int getRTAMajorVersion() {
        return this.rtaMajorVersion;
    }

    public String getSequencerFamily() {
        return this.sequencerFamily;
    }

    public String toString() {
        return "RunParameters{applicationName=" + this.applicationName + ", applicationVersion=" + this.applicationVersion + ", rtaVersion=" + this.rtaVersion + ", sequencerFamily=" + this.sequencerFamily + "}";
    }

    public static RunParameters parse(String filepath) throws ParserConfigurationException, SAXException, IOException {
        Objects.requireNonNull(filepath, "RunInfo.xml path cannot be null");
        return RunParameters.parse(new File(filepath));
    }

    public static RunParameters parse(File file) throws ParserConfigurationException, SAXException, IOException {
        Objects.requireNonNull(file, "file cannot be null");
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"RunParameters.xml does not exists or is not a file");
        return RunParameters.parse(new FileInputStream(file));
    }

    public static RunParameters parse(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        Objects.requireNonNull(is, "RunParameters.xml input stream cannot be null");
        try (InputStream in = is;){
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            doc.getDocumentElement().normalize();
            RunParameters runParameters = RunParameters.parse(doc);
            return runParameters;
        }
    }

    private static RunParameters parse(Document document) {
        Iterator iterator = XMLUtils.getElementsByTagName((Document)document, (String)"RunParameters").iterator();
        if (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            return XMLUtils.getTagValue((Element)e, (String)"RtaVersion") == null ? RunParameters.parseRTA12(e) : RunParameters.parseRTA3(e);
        }
        throw new KenetreRuntimeException("Invalid format of the RunParameters.xml file");
    }

    private static RunParameters parseRTA12(Element e) {
        String rtaVersion = XMLUtils.getTagValue((Element)e, (String)"RTAVersion");
        List elements = XMLUtils.getElementsByTagName((Element)e, (String)"Setup");
        if (!elements.isEmpty()) {
            Element setupElement = (Element)elements.get(0);
            String applicationName = XMLUtils.getTagValue((Element)setupElement, (String)"ApplicationName");
            String applicationVersion = XMLUtils.getTagValue((Element)setupElement, (String)"ApplicationVersion");
            if (rtaVersion == null) {
                rtaVersion = XMLUtils.getTagValue((Element)setupElement, (String)"RTAVersion");
            }
            return new RunParameters(applicationName, applicationVersion, rtaVersion);
        }
        throw new KenetreRuntimeException("Invalid format of the RunParameters.xml file");
    }

    private static RunParameters parseRTA3(Element e) {
        String rtaVersion = XMLUtils.getTagValue((Element)e, (String)"RtaVersion");
        String applicationName = XMLUtils.getTagValue((Element)e, (String)"ApplicationName");
        String applicationVersion = XMLUtils.getTagValue((Element)e, (String)"ApplicationVersion");
        return new RunParameters(applicationName, applicationVersion, rtaVersion);
    }

    private RunParameters(String applicationName, String applicationVersion, String rtaVersion) {
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.rtaVersion = rtaVersion;
        this.sequencerFamily = applicationName != null ? applicationName.substring(0, applicationName.indexOf(32)) : "Unknown";
        int rtaMajorVersion = -1;
        if (this.rtaVersion != null) {
            try {
                rtaMajorVersion = Integer.parseInt(rtaVersion.substring(0, rtaVersion.indexOf(46)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.rtaMajorVersion = rtaMajorVersion;
    }
}

