/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

abstract class AbstractBinaryFileReader<M> {
    private final File dirInterOpPath;
    private static final int HEADER_SIZE = 2;

    public abstract String getName();

    protected abstract File getMetricsFile();

    protected abstract int getExpectedRecordSize(int var1);

    protected abstract Set<Integer> getExpectedVersions();

    public File getDirPathInterOP() {
        return this.dirInterOpPath;
    }

    public List<M> readMetrics() throws KenetreException {
        MappedByteBuffer buf;
        ArrayList collection = new ArrayList();
        byte[] header = new byte[2];
        try {
            AbstractBinaryFileReader.checkExistingFile(this.getMetricsFile(), "Error binary file " + this.getMetricsFile().getAbsolutePath());
            FileInputStream is = new FileInputStream(this.getMetricsFile());
            FileChannel channel = is.getChannel();
            long fileSize = channel.size();
            buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            channel.close();
            is.close();
        }
        catch (IOException e) {
            throw new KenetreException((Throwable)e);
        }
        int version = -1;
        ByteBuffer b = ByteBuffer.allocate(2);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b = buf.get(header);
        b.position(0);
        version = Byte.toUnsignedInt(b.get());
        if (!this.getExpectedVersions().contains(version)) {
            throw new KenetreException(this.getName() + " expects the version number to be " + this.getExpectedVersions() + ".  Actual Version in Header(" + version + ")");
        }
        int recordSize = Byte.toUnsignedInt(b.get());
        this.readOptionalFlag(b, version);
        int expectedRecordSize = this.getExpectedRecordSize(version);
        if (expectedRecordSize != recordSize) {
            throw new KenetreException(this.getName() + " expects the record size to be " + expectedRecordSize + ". Actual Record Size in Header(" + recordSize + ")");
        }
        int recordSize2 = this.getExpectedRecordSize(version);
        byte[] element = new byte[recordSize2];
        ByteBuffer recordBuf = ByteBuffer.wrap(element);
        recordBuf.order(ByteOrder.LITTLE_ENDIAN);
        while (buf.limit() - buf.position() >= recordSize2) {
            recordBuf.position(0);
            buf.get(element);
            recordBuf.position(0);
            this.readMetricRecord(collection, recordBuf, version);
        }
        return collection;
    }

    protected void readOptionalFlag(ByteBuffer bb, int version) {
    }

    protected abstract void readMetricRecord(List<M> var1, ByteBuffer var2, int var3);

    private static void checkExistingFile(File file, String msgFileType) throws IOException {
        if (msgFileType == null) {
            throw new NullPointerException("Message file type for check isn't defined");
        }
        if (file == null) {
            throw new NullPointerException("The " + msgFileType + " is not defined. Please check and define " + msgFileType + " path and/or files.");
        }
        if (!file.exists()) {
            throw new IOException("The " + msgFileType + " does not exists: " + file.getAbsolutePath());
        }
    }

    public static final int uByteToInt(ByteBuffer bb) {
        return Byte.toUnsignedInt(bb.get());
    }

    public static final int uShortToInt(ByteBuffer bb) {
        return Short.toUnsignedInt(bb.getShort());
    }

    public static final long uIntToLong(ByteBuffer bb) {
        return Integer.toUnsignedLong(bb.getInt());
    }

    AbstractBinaryFileReader(File dirPath) throws KenetreException {
        if (dirPath == null) {
            throw new KenetreException("No path to the InterOp directory has been provided");
        }
        if (!dirPath.exists()) {
            throw new KenetreException("Path to interOp directory doesn't exists " + dirPath);
        }
        this.dirInterOpPath = dirPath;
    }
}

