/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.ErrorMetric;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ErrorMetricsReader
extends AbstractBinaryFileReader<ErrorMetric> {
    public static final String NAME = "ErrorMetricsOut";
    public static final String ERROR_METRICS_FILE = "ErrorMetricsOut.bin";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected File getMetricsFile() {
        return new File(this.getDirPathInterOP(), ERROR_METRICS_FILE);
    }

    @Override
    protected int getExpectedRecordSize(int version) {
        switch (version) {
            case 3: {
                return 30;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 16;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected Set<Integer> getExpectedVersions() {
        return new HashSet<Integer>(Arrays.asList(3, 4, 5));
    }

    @Override
    protected void readMetricRecord(List<ErrorMetric> collection, ByteBuffer bb, int version) {
        collection.add(new ErrorMetric(version, bb));
    }

    public ErrorMetricsReader(File dirPath) throws FileNotFoundException, KenetreException {
        super(dirPath);
        if (!new File(this.getDirPathInterOP(), ERROR_METRICS_FILE).exists()) {
            throw new FileNotFoundException();
        }
    }
}

