/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.ExtendedTileMetric;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExtendedTileMetricsReader
extends AbstractBinaryFileReader<ExtendedTileMetric> {
    public static final String NAME = "ExtendedTileMetricsOut";
    public static final String METRICS_FILE = "ExtendedTileMetricsOut.bin";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected File getMetricsFile() {
        return new File(this.getDirPathInterOP(), METRICS_FILE);
    }

    @Override
    protected int getExpectedRecordSize(int version) {
        switch (version) {
            case 1: 
            case 2: {
                return 10;
            }
            case 3: {
                return 18;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected Set<Integer> getExpectedVersions() {
        return new HashSet<Integer>(Arrays.asList(1, 2, 3));
    }

    @Override
    protected void readMetricRecord(List<ExtendedTileMetric> collection, ByteBuffer bb, int version) {
        collection.add(new ExtendedTileMetric(version, bb));
    }

    public ExtendedTileMetricsReader(File dirPath) throws KenetreException {
        super(dirPath);
    }
}

