/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.ExtractionMetric;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExtractionMetricsReader
extends AbstractBinaryFileReader<ExtractionMetric> {
    public static final String NAME = "ExtractionMetricsOut";
    public static final String EXTRACTION_METRICS_FILE = "ExtractionMetricsOut.bin";
    private int channelCount = 4;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected File getMetricsFile() {
        return new File(this.getDirPathInterOP(), EXTRACTION_METRICS_FILE);
    }

    @Override
    protected int getExpectedRecordSize(int version) {
        switch (version) {
            case 2: {
                return 38;
            }
            case 3: {
                return 8 + 6 * this.channelCount;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected Set<Integer> getExpectedVersions() {
        return new HashSet<Integer>(Arrays.asList(2, 3));
    }

    @Override
    protected void readOptionalFlag(ByteBuffer bb, int version) {
        switch (version) {
            case 2: {
                return;
            }
            case 3: {
                this.channelCount = ExtractionMetricsReader.uByteToInt(bb);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void readMetricRecord(List<ExtractionMetric> collection, ByteBuffer bb, int version) {
        collection.add(new ExtractionMetric(version, this.channelCount, bb));
    }

    public ExtractionMetricsReader(File dirPath) throws KenetreException {
        super(dirPath);
    }
}

