/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import java.util.List;
import java.util.Locale;
import java.util.Objects;

public abstract class Metric {
    protected String name;
    protected int version;

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public abstract List<String> fieldNames();

    public abstract List<Number> values();

    public abstract List<Class<?>> fieldTypes();

    public String csvHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("# ");
        sb.append(this.getName());
        sb.append(',');
        sb.append(this.getVersion());
        sb.append("\n# ");
        for (String fieldName : this.fieldNames()) {
            sb.append(fieldName);
            sb.append(',');
        }
        return sb.toString();
    }

    public String toCSV() {
        return Metric.toCSV(this.values());
    }

    public static String toCSV(List<Number> values) {
        Objects.requireNonNull(values);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Number n : values) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (n instanceof Float) {
                float f = n.floatValue();
                if (Float.isNaN(f)) {
                    sb.append("nan");
                    continue;
                }
                sb.append(String.format(Locale.ROOT, "%.6f", Float.valueOf(f)));
                continue;
            }
            sb.append(n);
        }
        return sb.toString();
    }
}

