/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.TileMetric;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TileMetricsReader
extends AbstractBinaryFileReader<TileMetric> {
    private float density;
    private Map<Integer, TileMetric> mapTile = new HashMap<Integer, TileMetric>();

    @Override
    public String getName() {
        return "TileMetricsOut";
    }

    @Override
    protected File getMetricsFile() {
        return new File(this.getDirPathInterOP(), this.getName() + ".bin");
    }

    @Override
    protected int getExpectedRecordSize(int version) {
        switch (version) {
            case 2: {
                return 10;
            }
            case 3: {
                return 15;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected Set<Integer> getExpectedVersions() {
        return new HashSet<Integer>(Arrays.asList(2, 3));
    }

    @Override
    protected void readOptionalFlag(ByteBuffer bb, int version) {
        if (version == 3) {
            this.density = bb.getFloat();
        }
    }

    @Override
    protected void readMetricRecord(List<TileMetric> collection, ByteBuffer bb, int version) {
        TileMetric tile;
        int laneNumber = -1;
        long tileNumber = -1L;
        switch (version) {
            case 2: {
                laneNumber = Short.toUnsignedInt(bb.getShort());
                tileNumber = Short.toUnsignedInt(bb.getShort());
                break;
            }
            case 3: {
                laneNumber = TileMetricsReader.uShortToInt(bb);
                tileNumber = TileMetricsReader.uIntToLong(bb);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int id = TileMetric.id(laneNumber, (int)tileNumber);
        if (this.mapTile.containsKey(id)) {
            tile = this.mapTile.get(id);
        } else {
            tile = new TileMetric(laneNumber, tileNumber);
            this.mapTile.put(id, tile);
            collection.add(tile);
        }
        switch (version) {
            case 2: {
                tile.parseV2(bb);
                break;
            }
            case 3: {
                tile.parseV3(bb, this.density);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public TileMetricsReader(File dirPath) throws KenetreException {
        super(dirPath);
    }
}

