/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PropertySection {
    private final Multimap<String, String> properties = LinkedListMultimap.create();

    public boolean containsKey(String key) {
        return this.containsKey(key);
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        Objects.requireNonNull(key);
        Collection result = this.properties.get((Object)key.trim());
        if (result == null || result.isEmpty()) {
            return defaultValue;
        }
        return (String)result.iterator().next();
    }

    public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public int getInt(String key) {
        String value = this.get(key);
        Objects.requireNonNull(value);
        return Integer.parseInt(value);
    }

    public void set(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        String trimmedKey = key.trim();
        if (trimmedKey.isEmpty()) {
            return;
        }
        this.properties.put((Object)trimmedKey, (Object)value.trim());
    }

    public void remove(String key) {
        Objects.requireNonNull(key);
        if (this.properties.containsKey((Object)key)) {
            this.properties.remove((Object)key, (Object)this.get(key.trim()));
        }
    }

    public Set<String> keySet() {
        return this.properties.keySet();
    }

    public Collection<Map.Entry<String, String>> entrySet() {
        return this.properties.entries();
    }

    public void clear() {
        this.clear();
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public String toString() {
        return this.properties.toString();
    }
}

