/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet;

import fr.ens.biologie.genomique.kenetre.KenetreRuntimeException;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.PropertySection;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.Sample;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.TableSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class SampleSheet
implements Iterable<Sample> {
    public static final String BCL2FASTQ_DEMUX_TABLE_NAME = "Data";
    public static final String BCLCONVERT_DEMUX_TABLE_NAME = "BCLConvert_Data";
    private static final String DEFAULT_TABLE_NAME = "Data";
    private List<String> sectionOrder = new ArrayList<String>();
    private Map<String, PropertySection> propertySections = new HashMap<String, PropertySection>();
    private Map<String, TableSection> tableSections = new HashMap<String, TableSection>();
    private TableSection defaultTable = null;
    private int version = 2;
    private String flowCellId;

    private TableSection getDefaultTableSection() {
        if (this.defaultTable == null) {
            return this.addTableSection("Data");
        }
        return this.defaultTable;
    }

    public PropertySection getPropertySection(String sectionName) {
        if (sectionName == null) {
            throw new NullPointerException("The section name cannot be null");
        }
        PropertySection result = this.propertySections.get(sectionName.trim());
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public TableSection getTableSection(String sectionName) {
        if (sectionName == null) {
            throw new NullPointerException("The section name cannot be null");
        }
        TableSection result = this.tableSections.get(sectionName.trim());
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public TableSection getDemuxSection() {
        if (this.containsTableSection("Data")) {
            return this.getTableSection("Data");
        }
        return this.getTableSection(BCLCONVERT_DEMUX_TABLE_NAME);
    }

    public boolean containsPropertySection(String sectionName) {
        if (sectionName == null) {
            throw new NullPointerException("The section name cannot be null");
        }
        return this.propertySections.containsKey(sectionName.trim());
    }

    public boolean containsTableSection(String sectionName) {
        if (sectionName == null) {
            throw new NullPointerException("The section name cannot be null");
        }
        return this.tableSections.containsKey(sectionName.trim());
    }

    public boolean containsSection(String sectionName) {
        if (sectionName == null) {
            throw new NullPointerException("The section name cannot be null");
        }
        return this.containsPropertySection(sectionName) || this.containsTableSection(sectionName);
    }

    @Deprecated
    public List<String> getMetadata(String sectionName, String key) {
        if (sectionName == null) {
            throw new NullPointerException("The section name cannot be null");
        }
        if (key == null) {
            throw new NullPointerException("The key name cannot be null");
        }
        String result = this.getPropertySection(sectionName).get(key);
        if (result == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(key, result);
    }

    public String getFlowCellId() {
        return this.flowCellId;
    }

    public int getVersion() {
        return this.version;
    }

    public List<String> getSections() {
        return Collections.unmodifiableList(this.sectionOrder);
    }

    @Deprecated
    public Map<String, List<String>> getSectionMetadata(String sectionName) {
        if (sectionName == null) {
            throw new NullPointerException("section argument cannot be null");
        }
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        PropertySection section = this.getPropertySection(sectionName);
        if (section == null) {
            return result;
        }
        for (String key : section.keySet()) {
            result.put(key, this.getMetadata(sectionName, key));
        }
        return result;
    }

    public PropertySection addPropertySection(String sectionName) {
        Objects.requireNonNull(sectionName);
        String trimmedSectionName = sectionName.trim();
        if (trimmedSectionName.isEmpty()) {
            throw new IllegalArgumentException("sectionName cannot be empty");
        }
        if (this.sectionOrder.contains(trimmedSectionName)) {
            throw new IllegalArgumentException("section already exists: " + sectionName);
        }
        PropertySection result = new PropertySection();
        this.propertySections.put(trimmedSectionName, result);
        this.sectionOrder.add(trimmedSectionName);
        return result;
    }

    public TableSection addTableSection(String sectionName) {
        Objects.requireNonNull(sectionName);
        String trimmedSectionName = sectionName.trim();
        if (trimmedSectionName.isEmpty()) {
            throw new IllegalArgumentException("sectionName cannot be empty");
        }
        if (this.sectionOrder.contains(trimmedSectionName)) {
            throw new IllegalArgumentException("section already exists: " + sectionName);
        }
        TableSection result = new TableSection(this);
        this.tableSections.put(trimmedSectionName, result);
        this.sectionOrder.add(trimmedSectionName);
        if (this.defaultTable == null) {
            this.defaultTable = result;
        }
        return result;
    }

    public void removeSection(String sectionName) {
        Objects.requireNonNull(sectionName);
        String trimmedSectionName = sectionName.trim();
        if (trimmedSectionName.isEmpty()) {
            throw new IllegalArgumentException("sectionName cannot be empty");
        }
        if (!this.sectionOrder.contains(trimmedSectionName)) {
            throw new IllegalArgumentException("section does not exists: " + sectionName);
        }
        if (this.propertySections.remove(trimmedSectionName) != null) {
            this.tableSections.remove(trimmedSectionName);
        }
        this.sectionOrder.remove(trimmedSectionName);
    }

    public void renameSection(String oldName, String newName) {
        Object s;
        Objects.requireNonNull(oldName);
        Objects.requireNonNull(newName);
        if (oldName.equals(newName)) {
            return;
        }
        String trimmedOldSectionName = oldName.trim();
        String trimmedNewSectionName = newName.trim();
        if (trimmedOldSectionName.isEmpty()) {
            throw new IllegalArgumentException("old section name cannot be empty");
        }
        if (trimmedNewSectionName.isEmpty()) {
            throw new IllegalArgumentException("new section name cannot be empty");
        }
        if (!this.sectionOrder.contains(trimmedOldSectionName)) {
            throw new IllegalArgumentException("section does not exists: " + oldName);
        }
        if (this.sectionOrder.contains(trimmedNewSectionName)) {
            throw new IllegalArgumentException("new section already exists: " + oldName);
        }
        if (this.propertySections.containsKey(trimmedOldSectionName)) {
            s = this.propertySections.remove(trimmedOldSectionName);
            this.propertySections.put(trimmedNewSectionName, (PropertySection)s);
        } else {
            s = this.tableSections.remove(trimmedOldSectionName);
            this.tableSections.put(trimmedNewSectionName, (TableSection)s);
        }
        int index = this.sectionOrder.indexOf(trimmedOldSectionName);
        this.sectionOrder.remove(index);
        this.sectionOrder.add(index, trimmedNewSectionName);
    }

    @Deprecated
    public void addMetadata(String section, String key, String value) {
        PropertySection propertySection;
        if (section == null) {
            throw new NullPointerException("The section name cannot be null");
        }
        if (key == null) {
            throw new NullPointerException("The key name cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("The value cannot be null");
        }
        String trimmedSection = section.trim();
        if (!this.propertySections.containsKey(trimmedSection)) {
            if (this.sectionOrder.contains(trimmedSection)) {
                throw new IllegalArgumentException("Section argument is a table section: " + section);
            }
            propertySection = this.addPropertySection(trimmedSection);
        } else {
            propertySection = this.getPropertySection(trimmedSection);
        }
        propertySection.set(key, value);
    }

    @Deprecated
    public void addMetadataSection(String section) {
        this.addPropertySection(section);
    }

    public void setFlowCellId(String flowcellId) {
        if (flowcellId == null) {
            throw new NullPointerException("The flowcellId argument cannot be null");
        }
        String trimmedFlowCellId = flowcellId.trim();
        if (this.flowCellId != null && !this.flowCellId.equals(trimmedFlowCellId)) {
            throw new KenetreRuntimeException("The samplesheet cannot handle two or more flowcell ids: " + flowcellId);
        }
        this.flowCellId = flowcellId;
    }

    public void setVersion(int version) {
        if (version < 1 || version > 2) {
            throw new KenetreRuntimeException("Unsupported samplesheet version: " + version);
        }
        this.version = version;
    }

    @Deprecated
    public Sample addSample() {
        return this.getDefaultTableSection().addSample();
    }

    @Override
    @Deprecated
    public Iterator<Sample> iterator() {
        return this.getDefaultTableSection().iterator();
    }

    public List<String> getSamplesFieldNames() {
        return this.getDefaultTableSection().getSamplesFieldNames();
    }

    @Deprecated
    public boolean isSampleFieldName(String fieldName) {
        return this.getDefaultTableSection().isSampleFieldName(fieldName);
    }

    @Deprecated
    public boolean isLaneSampleField() {
        return this.getDefaultTableSection().isLaneSampleField();
    }

    @Deprecated
    public boolean isSampleIdSampleField() {
        return this.getDefaultTableSection().isSampleIdSampleField();
    }

    @Deprecated
    public boolean isSampleNameSampleField() {
        return this.getDefaultTableSection().isSampleNameSampleField();
    }

    @Deprecated
    public boolean isDescriptionSampleField() {
        return this.getDefaultTableSection().isDescriptionSampleField();
    }

    @Deprecated
    public boolean isProjectSampleField() {
        return this.getDefaultTableSection().isProjectSampleField();
    }

    @Deprecated
    public boolean isIndex1SampleField() {
        return this.getDefaultTableSection().isIndex1SampleField();
    }

    @Deprecated
    public boolean isIndex2SampleField() {
        return this.getDefaultTableSection().isIndex2SampleField();
    }

    @Deprecated
    public List<Sample> getSampleInLane(int lane) {
        return this.getDefaultTableSection().getSampleInLane(lane);
    }

    @Deprecated
    public List<Sample> getSamples() {
        return this.getDefaultTableSection().getSamples();
    }

    @Deprecated
    public int size() {
        return this.getDefaultTableSection().size();
    }
}

