/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet;

import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.Sample;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TableSection
implements Iterable<Sample> {
    private final List<Sample> samples = new ArrayList<Sample>();
    private final SampleSheet samplesheet;

    public Sample addSample() {
        Sample sample = new Sample(this);
        this.samples.add(sample);
        return sample;
    }

    @Override
    public Iterator<Sample> iterator() {
        return this.samples.iterator();
    }

    public List<String> getSamplesFieldNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Sample s : this) {
            for (String fieldName : s.getFieldNames()) {
                if (result.contains(fieldName)) continue;
                result.add(fieldName);
            }
        }
        return result;
    }

    public boolean isSampleFieldName(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName argument cannot be null");
        }
        return this.getSamplesFieldNames().contains(fieldName);
    }

    public boolean isLaneSampleField() {
        return this.isSampleFieldName("_lane");
    }

    public boolean isSampleIdSampleField() {
        return this.isSampleFieldName("_sampleid");
    }

    public boolean isSampleNameSampleField() {
        return this.isSampleFieldName("_samplename");
    }

    public boolean isDescriptionSampleField() {
        return this.isSampleFieldName("_description");
    }

    public boolean isProjectSampleField() {
        return this.isSampleFieldName("_project");
    }

    public boolean isIndex1SampleField() {
        return this.isSampleFieldName("_index1");
    }

    public boolean isIndex2SampleField() {
        return this.isSampleFieldName("_index2");
    }

    public List<Sample> getSampleInLane(int lane) {
        if (lane < 1 || !this.isLaneSampleField()) {
            return Collections.emptyList();
        }
        ArrayList<Sample> result = new ArrayList<Sample>();
        for (Sample s : this) {
            if (s.getLane() != lane) continue;
            result.add(s);
        }
        return result;
    }

    public List<Sample> getSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    public int size() {
        return this.samples.size();
    }

    public boolean isEmpty() {
        return this.samples.isEmpty();
    }

    public SampleSheet getSampleSheet() {
        return this.samplesheet;
    }

    TableSection(SampleSheet samplesheet) {
        Objects.requireNonNull(samplesheet);
        this.samplesheet = samplesheet;
    }
}

