/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io;

import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheetUtils;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetDiscoverFormatParser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetParser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetReader;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetV1Parser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetV2Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class SampleSheetCSVReader
implements SampleSheetReader,
AutoCloseable {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final BufferedReader reader;
    private int version = -1;

    @Override
    public SampleSheet read() throws IOException {
        SampleSheetParser parser;
        switch (this.version) {
            case -1: {
                parser = new SampleSheetDiscoverFormatParser();
                break;
            }
            case 1: {
                parser = new SampleSheetV1Parser();
                break;
            }
            case 2: {
                parser = new SampleSheetV2Parser();
                break;
            }
            default: {
                throw new IOException("Unknown bcl2fastq samplesheet format version: " + this.version);
            }
        }
        String line = null;
        int count = 0;
        while ((line = this.reader.readLine()) != null) {
            ++count;
            if ("".equals(line = line.trim())) continue;
            try {
                parser.parseLine(SampleSheetUtils.parseCSVSamplesheetLine(line));
            }
            catch (IOException e) {
                throw new IOException(e.getMessage() + " in line #" + count + ": " + line, e);
            }
        }
        this.close();
        return parser.getSampleSheet();
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public SampleSheetCSVReader(InputStream is) {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.reader = new BufferedReader(new InputStreamReader(is, CHARSET));
    }

    public SampleSheetCSVReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        this.reader = new BufferedReader(new FileReader(file));
    }

    public SampleSheetCSVReader(Path path) throws IOException {
        this.reader = Files.newBufferedReader(path);
    }

    public SampleSheetCSVReader(String filename) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("Filename is null");
        }
        File file = new File(filename);
        if (!file.isFile()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        this.reader = new BufferedReader(new FileReader(file));
    }
}

