/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io;

import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheetUtils;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Objects;

public class SampleSheetCSVWriter
implements SampleSheetWriter,
AutoCloseable {
    private final Writer writer;
    private boolean addCommas;
    private int version = 2;

    @Override
    public void writer(SampleSheet samplesheet) throws IOException {
        String text;
        switch (this.version) {
            case 1: {
                text = SampleSheetUtils.toSampleSheetV1CSV(samplesheet);
                break;
            }
            case 2: {
                text = SampleSheetUtils.toSampleSheetV2CSV(samplesheet);
                break;
            }
            default: {
                throw new IOException("Unknown bcl2fastq samplesheet format version: " + this.version);
            }
        }
        this.writer.write(this.addCommas ? SampleSheetCSVWriter.addMissingComas(text) : text);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void addMissingCommas(boolean addCommas) {
        this.addCommas = addCommas;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static int maxCharacterInLines(String text) {
        Objects.requireNonNull(text);
        int max = 0;
        for (String s : text.split("\\n")) {
            max = Math.max(max, SampleSheetCSVWriter.commasInLine(s));
        }
        return max;
    }

    private static int commasInLine(String line) {
        Objects.requireNonNull(line);
        return line.length() - line.replace(",", "").length();
    }

    private static String addMissingComas(String text) {
        Objects.requireNonNull(text);
        int max = SampleSheetCSVWriter.maxCharacterInLines(text);
        StringBuilder sb = new StringBuilder();
        for (String s : text.split("\\n")) {
            sb.append(s);
            for (int i = SampleSheetCSVWriter.commasInLine(s); i < max; ++i) {
                sb.append(',');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public SampleSheetCSVWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("The writer is null.");
        }
        this.writer = writer;
    }

    public SampleSheetCSVWriter(OutputStream os) throws FileNotFoundException {
        this.writer = new OutputStreamWriter(os);
    }

    public SampleSheetCSVWriter(File outputFile) throws IOException {
        this.writer = new FileWriter(outputFile);
    }

    public SampleSheetCSVWriter(String outputFilename) throws IOException {
        this.writer = new FileWriter(outputFilename);
    }
}

