/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io;

import java.io.IOException;
import java.util.List;

public class SampleSheetReaderUtils {
    public static final void trimFields(List<String> fields) throws IOException {
        if (fields == null) {
            throw new IOException("The fields are null");
        }
        for (int i = 0; i < fields.size(); ++i) {
            String val = fields.get(i);
            if (val == null) {
                throw new IOException("Found null field.");
            }
            fields.set(i, val.trim());
        }
    }

    public static final void checkFields(List<String> fields) throws IOException {
        if (fields.size() == 10) {
            return;
        }
        if (fields.size() < 10) {
            throw new IOException("Invalid number of field (" + fields.size() + "), 10 excepted.");
        }
        for (int i = 10; i < fields.size(); ++i) {
            if ("".equals(fields.get(i).trim())) continue;
            throw new IOException("Invalid number of field (" + fields.size() + "), 10 excepted.");
        }
    }

    public static final int parseLane(String s) throws IOException {
        double d;
        if (s == null) {
            return 0;
        }
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid lane number: " + s);
        }
        int result = (int)d;
        if (d - (double)result > 0.0) {
            throw new IOException("Invalid lane number: " + s);
        }
        return result;
    }

    private SampleSheetReaderUtils() {
    }
}

