/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io;

import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.Sample;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.TableSection;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetParser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetReaderUtils;
import java.io.IOException;
import java.util.List;

public class SampleSheetV1Parser
implements SampleSheetParser {
    static final String[] FIELDNAMES = new String[]{"FCID", "Lane", "SampleID", "SampleRef", "Index", "Description", "Control", "Recipe", "Operator", "SampleProject"};
    private final SampleSheet samplesheet = new SampleSheet();
    private final TableSection tableSection;
    private boolean firstLine = true;

    private String convertFieldName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        if ("Lane".equals(fieldName)) {
            return "_lane";
        }
        if ("SampleID".equals(fieldName)) {
            return "_sampleid";
        }
        if ("Description".equals(fieldName)) {
            return "_description";
        }
        if ("SampleProject".equals(fieldName)) {
            return "_project";
        }
        if ("SampleRef".equals(fieldName)) {
            return "_sampleref";
        }
        return fieldName;
    }

    @Override
    public void parseLine(List<String> fields) throws IOException {
        SampleSheetReaderUtils.trimFields(fields);
        SampleSheetReaderUtils.checkFields(fields);
        if (this.firstLine) {
            this.firstLine = false;
            for (int i = 0; i < fields.size(); ++i) {
                if (FIELDNAMES[i].toLowerCase().equals(fields.get(i).toLowerCase())) continue;
                throw new IOException("Invalid field name: " + fields.get(i));
            }
            return;
        }
        Sample sample = this.tableSection.addSample();
        this.samplesheet.setFlowCellId(fields.get(0));
        sample.set(this.convertFieldName(FIELDNAMES[1]), "" + SampleSheetReaderUtils.parseLane(fields.get(1)));
        sample.set(this.convertFieldName(FIELDNAMES[2]), fields.get(2));
        sample.set(this.convertFieldName(FIELDNAMES[3]), fields.get(3));
        sample.set(this.convertFieldName(FIELDNAMES[5]), fields.get(5));
        String indexes = fields.get(4);
        if (indexes.isEmpty()) {
            sample.setIndex1("");
            sample.setIndex2("");
        } else {
            String[] indexArray = indexes.split("-");
            if (indexArray.length > 2) {
                throw new IOException("More than two indexes found: " + indexes);
            }
            sample.setIndex1(indexArray[0]);
            sample.setIndex2(indexArray.length == 1 ? "" : indexArray[1]);
        }
        sample.set(this.convertFieldName(FIELDNAMES[5]), fields.get(5));
        sample.set(this.convertFieldName(FIELDNAMES[6]), "" + SampleSheetV1Parser.parseControlField(fields.get(6)));
        sample.set(this.convertFieldName(FIELDNAMES[7]), fields.get(7));
        sample.set(this.convertFieldName(FIELDNAMES[8]), fields.get(8));
        sample.set(this.convertFieldName(FIELDNAMES[9]), fields.get(9));
    }

    private static boolean parseControlField(String value) throws IOException {
        if ("".equals(value)) {
            throw new IOException("Empty value in the control field");
        }
        if ("Y".equals(value) || "y".equals(value)) {
            return true;
        }
        if ("N".equals(value) || "n".equals(value)) {
            return false;
        }
        throw new IOException("Invalid value for the control field: " + value);
    }

    @Override
    public SampleSheet getSampleSheet() {
        return this.samplesheet;
    }

    public SampleSheetV1Parser() {
        this.samplesheet.setVersion(1);
        this.tableSection = this.samplesheet.addTableSection("Data");
    }
}

