/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io;

import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.PropertySection;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.Sample;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.TableSection;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetParser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetReaderUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SampleSheetV2Parser
implements SampleSheetParser {
    public static final String DATA_SECTION_NAME = "data";
    private final SampleSheet samplesheet;
    private PropertySection propertySection;
    private TableSection tableSection;
    private List<String> header = new ArrayList<String>();

    private String convertFieldName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        if ("Sample_Project".equals(fieldName)) {
            return "_project";
        }
        if ("Lane".equals(fieldName)) {
            return "_lane";
        }
        if ("Sample_ID".equals(fieldName)) {
            return "_sampleid";
        }
        if ("Sample_Name".equals(fieldName)) {
            return "_samplename";
        }
        if ("index".equals(fieldName)) {
            return "_index1";
        }
        if ("index2".equals(fieldName)) {
            return "_index2";
        }
        if ("Description".equals(fieldName)) {
            return "_description";
        }
        if ("Sample_Ref".equals(fieldName)) {
            return "_sampleref";
        }
        return fieldName;
    }

    @Override
    public void parseLine(List<String> fields) throws IOException {
        SampleSheetReaderUtils.trimFields(fields);
        if (fields.isEmpty()) {
            return;
        }
        String firstField = fields.get(0);
        if (firstField.isEmpty()) {
            return;
        }
        if (firstField.startsWith("[")) {
            if (!firstField.endsWith("]")) {
                throw new IOException("Section header do not ends with ']': " + firstField);
            }
            String sectionName = firstField.substring(1, firstField.length() - 1).trim();
            if (sectionName.toLowerCase().endsWith(DATA_SECTION_NAME)) {
                this.tableSection = this.samplesheet.addTableSection(sectionName);
                this.header.clear();
                this.propertySection = null;
            } else {
                this.tableSection = null;
                this.propertySection = this.samplesheet.addPropertySection(sectionName);
            }
            return;
        }
        if (this.propertySection != null) {
            String value = fields.size() > 1 ? fields.get(1).trim() : "";
            this.propertySection.set(fields.get(0), value);
            return;
        }
        if (this.tableSection != null) {
            if (this.header.isEmpty()) {
                this.header.addAll(fields);
                return;
            }
            Sample sample = this.tableSection.addSample();
            int headerLength = this.header.size();
            for (int i = 0; i < headerLength; ++i) {
                String value;
                String key = this.convertFieldName(this.header.get(i));
                String string = value = i < fields.size() ? fields.get(i) : "";
                if ("_lane".equals(key)) {
                    value = "" + SampleSheetReaderUtils.parseLane(value);
                }
                sample.set(key, value);
            }
        }
    }

    @Override
    public SampleSheet getSampleSheet() {
        return this.samplesheet;
    }

    protected SampleSheetV2Parser() {
        this.samplesheet = new SampleSheet();
        this.samplesheet.setVersion(2);
    }
}

