/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.Matrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class AbstractMatrix<E>
implements Matrix<E> {
    @Override
    public Iterable<Matrix.Entry<E>> values() {
        return new Iterable<Matrix.Entry<E>>(){

            @Override
            public Iterator<Matrix.Entry<E>> iterator() {
                final Iterator<String> rowNames = AbstractMatrix.this.getRowNames().iterator();
                final List<String> columnNames = AbstractMatrix.this.getColumnNames();
                return new Iterator<Matrix.Entry<E>>(){
                    Iterator<String> columnIterator;
                    String columnName;
                    String rowName;
                    boolean first;
                    {
                        this.columnIterator = columnNames.iterator();
                        this.first = true;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public boolean hasNext() {
                        return rowNames.hasNext() || this.columnIterator.hasNext();
                    }

                    @Override
                    public Matrix.Entry<E> next() {
                        if (this.first) {
                            this.rowName = (String)rowNames.next();
                            this.first = false;
                        }
                        this.columnName = this.columnIterator.next();
                        BasicEntry result = new BasicEntry(this.rowName, this.columnName, AbstractMatrix.this.getValue(this.rowName, this.columnName));
                        if (!this.columnIterator.hasNext() && rowNames.hasNext()) {
                            this.rowName = (String)rowNames.next();
                            this.columnIterator = columnNames.iterator();
                        }
                        return result;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<Matrix.Entry<E>> nonZeroValues() {
        return new Iterable<Matrix.Entry<E>>(){
            private final Iterator<Matrix.Entry<E>> values;
            {
                this.values = AbstractMatrix.this.values().iterator();
            }

            @Override
            public Iterator<Matrix.Entry<E>> iterator() {
                return new Iterator<Matrix.Entry<E>>(){
                    Matrix.Entry<E> nextValue;

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public boolean hasNext() {
                        while (values.hasNext()) {
                            this.nextValue = (Matrix.Entry)values.next();
                            if (this.nextValue.getValue() == AbstractMatrix.this.getDefaultValue()) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Matrix.Entry<E> next() {
                        return this.nextValue;
                    }
                };
            }
        };
    }

    @Override
    public void addRows(List<String> rowNames) {
        Objects.requireNonNull("rowNames argument cannot be null");
        for (String rowName : rowNames) {
            this.addRow(rowName);
        }
    }

    @Override
    public void addRows(String ... rowNames) {
        Objects.requireNonNull("rowNames argument cannot be null");
        for (String rowName : rowNames) {
            this.addRow(rowName);
        }
    }

    @Override
    public void addColumns(List<String> columnNames) {
        Objects.requireNonNull(columnNames, "columnName argument cannot be null");
        for (String columnName : columnNames) {
            this.addColumn(columnName);
        }
    }

    @Override
    public void addColumns(String ... columnNames) {
        Objects.requireNonNull(columnNames);
        for (String columnName : columnNames) {
            this.addColumn(columnName);
        }
    }

    @Override
    public void add(Matrix<E> matrix) {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        List<String> newColumnNames = matrix.getColumnNames();
        List<String> newRowNames = matrix.getRowNames();
        for (String rowName : newRowNames) {
            for (String columnName : newColumnNames) {
                this.setValue(rowName, columnName, matrix.getValue(rowName, columnName));
            }
        }
    }

    @Override
    public void removeRows(Collection<String> rowNames) {
        Objects.requireNonNull(rowNames);
        for (String rowName : rowNames) {
            this.removeRow(rowName);
        }
    }

    @Override
    public void removeColumns(Collection<String> columnNames) {
        Objects.requireNonNull(columnNames);
        for (String columnName : columnNames) {
            this.removeColumn(columnName);
        }
    }

    @Override
    public void retainRows(Collection<String> rowNames) {
        Objects.requireNonNull(rowNames);
        ArrayList<String> rowsToRemove = new ArrayList<String>(this.getRowNames());
        rowsToRemove.removeAll(rowNames);
        this.removeRows(rowsToRemove);
    }

    @Override
    public void retainColumns(Collection<String> columnNames) {
        Objects.requireNonNull(columnNames);
        ArrayList<String> columnsToRemove = new ArrayList<String>(this.getColumnNames());
        columnsToRemove.removeAll(columnNames);
        this.removeColumns(columnsToRemove);
    }

    @Override
    public int size() {
        return this.getRowCount() * this.getColumnCount();
    }

    @Override
    public boolean isEmpty() {
        return this.getColumnCount() == 0 && this.getRowCount() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Id");
        for (String columnName : this.getColumnNames()) {
            sb.append('\t');
            sb.append(columnName);
        }
        sb.append('\n');
        for (String rowName : this.getRowNames()) {
            sb.append(rowName);
            for (Object value : this.getRowValues(rowName)) {
                sb.append('\t');
                sb.append(value);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    static class BasicEntry<E>
    implements Matrix.Entry<E> {
        final String rowName;
        final String columnName;
        final E value;

        @Override
        public String getRowName() {
            return this.rowName;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.rowName, this.columnName, this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BasicEntry)) {
                return false;
            }
            BasicEntry that = (BasicEntry)o;
            return Objects.equals(this.rowName, that.rowName) && Objects.equals(this.columnName, that.columnName) && Objects.equals(this.value, that.value);
        }

        public String toString() {
            return this.rowName + ':' + this.columnName + '=' + this.value;
        }

        BasicEntry(String rowName, String columnName, E value) {
            this.rowName = rowName;
            this.columnName = columnName;
            this.value = value;
        }
    }
}

