/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.EntryMetadata;
import fr.ens.biologie.genomique.kenetre.bio.GenomicInterval;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BEDEntry {
    private final EntryMetadata metadata;
    private String chromosomeName;
    private int start;
    private int end;
    private String name;
    private String score;
    private char strand;
    private int thickStart;
    private int thickEnd;
    private String rgbItem;
    private final List<GenomicInterval> blocks = new ArrayList<GenomicInterval>();

    public final EntryMetadata getMetadata() {
        return this.metadata;
    }

    @Deprecated
    public final Set<String> getMetadataKeyNames() {
        return this.metadata.keySet();
    }

    @Deprecated
    public final boolean isMetaDataEntry(String key) {
        return this.metadata.containsKey(key);
    }

    @Deprecated
    public final List<String> getMetadataEntryValues(String key) {
        return this.metadata.get(key);
    }

    public String getChromosomeName() {
        return this.chromosomeName;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start + 1;
    }

    public String getName() {
        return this.name;
    }

    public String getScore() {
        return this.score;
    }

    public char getStrand() {
        return this.strand;
    }

    public int getThickStart() {
        return this.thickStart;
    }

    public int getThickEnd() {
        return this.thickEnd;
    }

    public int getThickLength() {
        return this.thickStart == -1 || this.getThickEnd() == -1 ? 0 : this.thickEnd - this.thickStart + 1;
    }

    public String getRgbItem() {
        return this.rgbItem;
    }

    public int getBlockCount() {
        return this.blocks.size();
    }

    public List<Integer> getBlockSizes() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.blocks.size());
        for (GenomicInterval b : this.blocks) {
            result.add(b.getLength());
        }
        return result;
    }

    public List<Integer> getBlockStarts() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.blocks.size());
        for (GenomicInterval b : this.blocks) {
            result.add(b.getStart());
        }
        return result;
    }

    public List<Integer> getBlockEnds() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.blocks.size());
        for (GenomicInterval b : this.blocks) {
            result.add(b.getEnd());
        }
        return result;
    }

    public List<GenomicInterval> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    @Deprecated
    public final boolean addMetaDataEntry(String key, String value) {
        return this.metadata.add(key, value);
    }

    public final boolean addMetaDataEntries(Map<String, List<String>> entries) {
        return this.metadata.add(entries);
    }

    public final boolean removeMetaDataEntry(String key) {
        return this.metadata.remove(key);
    }

    public void setChromosomeName(String chromosomeName) {
        if (chromosomeName == null) {
            throw new NullPointerException("chromosomeName argument cannot be null");
        }
        this.chromosomeName = chromosomeName;
    }

    public void setStart(int start) {
        if (start < 1) {
            throw new IllegalArgumentException("chromosomeStart argument cannot be lower than zero: " + start);
        }
        this.start = start;
    }

    public void setEnd(int end) {
        if (end < 1) {
            throw new IllegalArgumentException("chromosomeEnd argument cannot be lower than zero: " + end);
        }
        this.end = end;
    }

    public void setName(String name) {
        Objects.requireNonNull(name, "name argument cannot be null");
        this.name = name.trim();
    }

    public void setScore(String score) {
        this.score = score;
    }

    public void setScore(int score) {
        if (score < 0 || score > 1000) {
            throw new IllegalArgumentException("score must be in the range 0 - 1000: " + score);
        }
        this.score = Integer.toString(score);
    }

    public void setScore(double score) {
        this.score = Double.toString(score);
    }

    public void setStrand(char strand) {
        switch (strand) {
            case '\u0000': 
            case '+': 
            case '-': {
                this.strand = strand;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid strand value: " + strand);
            }
        }
    }

    public void setThickStart(int thickStart) {
        if (thickStart < 1) {
            throw new IllegalArgumentException("thickStart argument cannot be lower than zero: " + thickStart);
        }
        this.thickStart = thickStart;
    }

    public void setThickEnd(int thickEnd) {
        if (thickEnd < 1) {
            throw new IllegalArgumentException("thickEnd argument cannot be lower than zero: " + thickEnd);
        }
        this.thickEnd = thickEnd;
    }

    public void setRgbItem(String rgbItem) {
        this.rgbItem = rgbItem;
    }

    public void setRgbItem(int r, int g, int b) {
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("red value must be in [0-255] interval: " + r);
        }
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("green value must be in [0-255] interval: " + g);
        }
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("blue value must be in [0-255] interval: " + b);
        }
        this.rgbItem = "" + r + ',' + g + ',' + b;
    }

    public boolean addBlock(int startBlock, int endBlock) {
        return this.blocks.add(new GenomicInterval(this.chromosomeName, startBlock, endBlock, this.strand == '\u0000' ? (char)'.' : (char)this.strand));
    }

    public boolean removeBlock(int startBlock, int endBlock) {
        GenomicInterval block = new GenomicInterval(this.chromosomeName, startBlock, endBlock, this.strand == '\u0000' ? (char)'.' : (char)this.strand);
        return this.blocks.remove(block);
    }

    public String toBED() {
        return this.toBED(12);
    }

    public String toBED(int fieldCount) {
        BEDEntry.checkBEDFieldCount(fieldCount);
        StringBuilder sb = new StringBuilder();
        sb.append(this.chromosomeName);
        sb.append('\t');
        sb.append(this.start == -1 ? 0 : this.start - 1);
        sb.append('\t');
        sb.append(this.end == -1 ? 0 : this.end);
        if (fieldCount == 3) {
            return sb.toString();
        }
        sb.append('\t');
        sb.append(this.name);
        if (fieldCount == 4) {
            return sb.toString();
        }
        sb.append('\t');
        sb.append(this.score);
        if (fieldCount == 5) {
            return sb.toString();
        }
        sb.append('\t');
        sb.append(this.strand != '\u0000' ? Character.valueOf(this.strand) : "");
        if (fieldCount == 6) {
            return sb.toString();
        }
        sb.append('\t');
        sb.append(this.getThickStart() == -1 ? "0" : Integer.valueOf(this.thickStart - 1));
        sb.append('\t');
        sb.append(this.getThickEnd() == -1 ? "0" : Integer.valueOf(this.thickEnd));
        if (fieldCount == 8) {
            return sb.toString();
        }
        sb.append('\t');
        sb.append(this.rgbItem);
        if (fieldCount == 9) {
            return sb.toString();
        }
        sb.append('\t');
        sb.append(this.getBlockCount());
        sb.append('\t');
        for (int i : this.getBlockSizes()) {
            sb.append(i - 1);
            sb.append(',');
        }
        sb.append('\t');
        for (int i : this.getBlockStarts()) {
            sb.append(i - this.start);
            sb.append(',');
        }
        return sb.toString();
    }

    public String toString() {
        return this.toBED(12);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.chromosomeName, this.start, this.end, this.name, this.score, Character.valueOf(this.strand), this.thickStart, this.thickEnd, this.rgbItem, this.blocks);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BEDEntry)) {
            return false;
        }
        BEDEntry that = (BEDEntry)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.chromosomeName, that.chromosomeName) && this.start == that.start && this.end == that.end && Objects.equals(this.name, that.name) && Objects.equals(this.score, that.score) && this.strand == that.strand && this.thickStart == that.thickStart && this.thickEnd == that.thickEnd && Objects.equals(this.rgbItem, that.rgbItem) && Objects.equals(this.blocks, that.blocks);
    }

    public void parse(String s) throws BadBioEntryException {
        if (s == null) {
            throw new NullPointerException("s argument cannot be null");
        }
        int count = s.length() - s.replace("\t", "").length() + 1;
        this.parse(s, count);
    }

    public void parse(String s, int requiredFieldCount) throws BadBioEntryException {
        if (s == null) {
            throw new NullPointerException("s argument cannot be null");
        }
        BEDEntry.checkBEDFieldCount(requiredFieldCount);
        this.clear();
        Splitter splitter = Splitter.on((char)'\t').trimResults();
        List fields = GuavaCompatibility.splitToList((Splitter)splitter, (CharSequence)s);
        this.chromosomeName = (String)fields.get(0);
        if (this.chromosomeName.isEmpty()) {
            throw new BadBioEntryException("chromosome name is empty", s);
        }
        this.start = BEDEntry.parseCoordinate((String)fields.get(1), 1, Integer.MIN_VALUE);
        this.end = BEDEntry.parseCoordinate((String)fields.get(2), 0, Integer.MAX_VALUE);
        if (requiredFieldCount == 3) {
            return;
        }
        this.name = (String)fields.get(3);
        if (requiredFieldCount == 4) {
            return;
        }
        this.score = (String)fields.get(4);
        if (requiredFieldCount == 5) {
            return;
        }
        switch ((String)fields.get(5)) {
            case "+": 
            case "-": {
                this.strand = ((String)fields.get(5)).charAt(0);
                break;
            }
            default: {
                this.strand = '\u0000';
            }
        }
        if (requiredFieldCount == 6) {
            return;
        }
        this.thickStart = BEDEntry.parseCoordinate((String)fields.get(6), 1, Integer.MIN_VALUE);
        this.thickEnd = BEDEntry.parseCoordinate((String)fields.get(7), 0, Integer.MAX_VALUE);
        if (requiredFieldCount == 8) {
            return;
        }
        this.setRgbItem((String)fields.get(8));
        if (requiredFieldCount == 9) {
            return;
        }
        int blockCount = BEDEntry.parseInt((String)fields.get(9), -1);
        if (blockCount == -1) {
            throw new BadBioEntryException("Invalid block count: " + (String)fields.get(9), s);
        }
        List<Integer> sizes = this.parseIntList((String)fields.get(10));
        List<Integer> starts = this.parseIntList((String)fields.get(11));
        if (starts.size() != blockCount) {
            throw new BadBioEntryException("Invalid block starts: " + blockCount + "\t" + starts.size() + "\t" + (String)fields.get(10), s);
        }
        if (sizes.size() != blockCount) {
            throw new BadBioEntryException("Invalid block sizes: " + (String)fields.get(11), s);
        }
        for (int i = 0; i < blockCount; ++i) {
            this.addBlock(this.start + starts.get(i), this.start + starts.get(i) + sizes.get(i));
        }
    }

    private static int parseInt(String s, int defaultValue) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static int parseCoordinate(String s, int diff, int defaultValue) {
        try {
            return Integer.parseInt(s.trim()) + diff;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private List<Integer> parseIntList(String s) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String v : splitter.split((CharSequence)s)) {
            try {
                result.add(Integer.parseInt(v));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void clear() {
        this.chromosomeName = "";
        this.start = -1;
        this.end = -1;
        this.name = "";
        this.score = "";
        this.strand = '\u0000';
        this.thickStart = -1;
        this.thickEnd = -1;
        this.rgbItem = "0";
        this.blocks.clear();
    }

    public final void clearMetaData() {
        this.metadata.clear();
    }

    public static void checkBEDFieldCount(int fieldCount) {
        if (fieldCount < 3 || fieldCount > 12 || fieldCount == 7 || fieldCount == 10 || fieldCount == 11) {
            throw new IllegalArgumentException("Invalid required field count: " + fieldCount);
        }
    }

    public BEDEntry() {
        this(new EntryMetadata());
    }

    public BEDEntry(EntryMetadata metadata) {
        Objects.requireNonNull(metadata, " metadata argument cannot  be null");
        this.metadata = metadata;
        this.clear();
    }
}

