/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ens.biologie.genomique.kenetre.bio.AbstractMatrix;
import fr.ens.biologie.genomique.kenetre.bio.DenseExpressionMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DenseMatrix<E>
extends AbstractMatrix<E> {
    private final Multimap<String, E> values = ArrayListMultimap.create();
    private final Map<String, Integer> columnIndex = new HashMap<String, Integer>();
    private final Set<String> rowOrder = new LinkedHashSet<String>();
    private final E defaultValue;

    @Override
    public List<String> getRowNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.rowOrder));
    }

    @Override
    public int getRowCount() {
        return this.rowOrder.size();
    }

    @Override
    public List<String> getColumnNames() {
        String[] result = new String[this.columnIndex.size()];
        for (Map.Entry<String, Integer> e : this.columnIndex.entrySet()) {
            result[e.getValue().intValue()] = e.getKey();
        }
        return Collections.unmodifiableList(Arrays.asList(result));
    }

    @Override
    public int getColumnCount() {
        return this.columnIndex.size();
    }

    @Override
    public List<E> getColumnValues(String columnName) {
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        ArrayList<E> result = new ArrayList<E>(this.rowOrder.size());
        for (String rowName : this.rowOrder) {
            result.add(this.getValue(rowName, columnName));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<E> getRowValues(String rowName) {
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        return (List)this.values.get((Object)rowName);
    }

    @Override
    public E getValue(String rowName, String columnName) {
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        if (!this.columnIndex.containsKey(columnName)) {
            throw new IllegalArgumentException("Unknown column name: " + columnName);
        }
        if (!this.rowOrder.contains(rowName)) {
            throw new IllegalArgumentException("Unknown row name: " + rowName);
        }
        return this.getRowValues(rowName).get(this.columnIndex.get(columnName));
    }

    @Override
    public boolean containsColumn(String columnName) {
        return this.columnIndex.containsKey(columnName);
    }

    @Override
    public boolean containsRow(String rowName) {
        if (this.columnIndex.size() == 0) {
            return this.rowOrder.contains(rowName);
        }
        return this.values.containsKey((Object)rowName);
    }

    @Override
    public void setValue(String rowName, String columnName, E value) {
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        if (!this.columnIndex.containsKey(columnName)) {
            this.addColumn(columnName);
        }
        if (!this.values.containsKey((Object)rowName)) {
            this.addRow(rowName);
        }
        ((List)this.values.get((Object)rowName)).set(this.columnIndex.get(columnName), value);
    }

    @Override
    public void addRow(String rowName) {
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        if (this.rowOrder.contains(rowName)) {
            return;
        }
        this.values.putAll((Object)rowName, Collections.nCopies(this.columnIndex.size(), this.defaultValue));
        this.rowOrder.add(rowName);
    }

    @Override
    public void addColumn(String columnName) {
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        if (this.columnIndex.containsKey(columnName)) {
            return;
        }
        this.columnIndex.put(columnName, this.columnIndex.size());
        if (this.columnIndex.size() == 1 && !this.rowOrder.isEmpty()) {
            for (String rowName : this.rowOrder) {
                this.values.put((Object)rowName, this.defaultValue);
            }
        } else {
            for (Collection list : this.values.asMap().values()) {
                list.add(this.defaultValue);
            }
        }
    }

    @Override
    public void renameColumn(String oldColumnName, String newColumnName) {
        Objects.requireNonNull(oldColumnName, "oldColumnName cannot be null");
        Objects.requireNonNull(newColumnName, "newColumnName cannot be null");
        if (!this.containsColumn(oldColumnName)) {
            throw new IllegalArgumentException("Unknown column name: " + oldColumnName);
        }
        if (this.containsColumn(newColumnName)) {
            throw new IllegalArgumentException("The new column name already exists: " + newColumnName);
        }
        this.columnIndex.put(newColumnName, this.columnIndex.get(oldColumnName));
        this.columnIndex.remove(oldColumnName);
    }

    @Override
    public void removeColumn(String columnName) {
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        if (!this.columnIndex.containsKey(columnName)) {
            throw new IllegalArgumentException("columnName does not exists: " + columnName);
        }
        int columnIndex = this.columnIndex.get(columnName);
        for (Collection list : this.values.asMap().values()) {
            ((List)list).remove(columnIndex);
        }
        this.columnIndex.remove(columnName);
    }

    @Override
    public void removeRow(String rowName) {
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        if (!this.rowOrder.contains(rowName)) {
            throw new IllegalArgumentException("rowName does not exists: " + rowName);
        }
        this.values.removeAll((Object)rowName);
        this.rowOrder.remove(rowName);
    }

    @Override
    public E getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DenseExpressionMatrix)) {
            return false;
        }
        DenseMatrix that = (DenseMatrix)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.columnIndex, that.columnIndex) && Objects.equals(this.rowOrder, that.rowOrder);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.columnIndex, this.rowOrder);
    }

    public DenseMatrix(E defaultValue) {
        this.defaultValue = defaultValue;
    }
}

