/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class EntryMetadata {
    private final Map<String, List<String>> map = new LinkedHashMap<String, List<String>>();

    public boolean add(String key, String value) {
        List<Object> list;
        if (key == null || value == null) {
            return false;
        }
        if (!this.map.containsKey(key)) {
            list = new ArrayList();
            this.map.put(key, list);
        } else {
            list = this.map.get(key);
        }
        list.add(value);
        return true;
    }

    public boolean add(EntryMetadata metadata) {
        if (metadata == null) {
            return false;
        }
        return this.add(metadata.entries());
    }

    public boolean add(Map<String, List<String>> entries) {
        if (entries == null) {
            return false;
        }
        for (Map.Entry<String, List<String>> e : entries.entrySet()) {
            if (e.getValue() == null) {
                return false;
            }
            for (String v : e.getValue()) {
                if (this.add(e.getKey(), v)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public List<String> get(String key) {
        List<String> list = this.map.get(key);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Map<String, List<String>> entries() {
        return Collections.unmodifiableMap(this.map);
    }

    public final boolean remove(String key) {
        return this.map.remove(key) != null;
    }

    public void clear() {
        this.map.clear();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntryMetadata)) {
            return false;
        }
        EntryMetadata that = (EntryMetadata)o;
        return this.map.equals(that.map);
    }

    public String toString() {
        return this.map.toString();
    }

    public EntryMetadata() {
    }

    public EntryMetadata(EntryMetadata metadata) {
        Objects.requireNonNull(metadata, "metadata argument cannot be null");
        this.add(metadata);
    }
}

