/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public enum FastqFormat {
    FASTQ_SANGER("fastq-sanger", new String[]{"sanger", "fastq-illumina-1.8", "illumina-1.8", "1.8"}, "1.8", 0, 93, 40, 33, true),
    FASTQ_SOLEXA("fastq-solexa", new String[]{"solexa", "fastq-solexa-1.0", "solexa-1.0", "1.0"}, "1.0", -5, 62, 40, 64, false),
    FASTQ_ILLUMINA("fastq-illumina-1.3", new String[]{"fastq-illumina", "illumina", "illumina-1.3", "1.3"}, "1.3", 0, 62, 40, 64, true),
    FASTQ_ILLUMINA_1_5("fastq-illumina-1.5", new String[]{"illumina-1.5", "1.5"}, "1.5", 2, 62, 40, 64, true);

    private final String name;
    private final Set<String> alias;
    private final String illuminaVersion;
    private final int scoreMin;
    private final int scoreMax;
    private final int scoreMaxExpected;
    private final int asciiOffset;
    private final boolean phredScore;

    public String getName() {
        return this.name;
    }

    public Set<String> getAlias() {
        if (this.alias == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.alias);
    }

    public String getIlluminaVersion() {
        return this.illuminaVersion;
    }

    public int getScoreMin() {
        return this.scoreMin;
    }

    public int getScoreMax() {
        return this.scoreMax;
    }

    public int getAsciiOffset() {
        return this.asciiOffset;
    }

    public int getScoreMaxExpected() {
        return this.scoreMaxExpected;
    }

    public boolean isPhredScore() {
        return this.phredScore;
    }

    public char getCharMin() {
        return (char)(this.asciiOffset + this.scoreMin);
    }

    public char getCharMax() {
        return (char)(this.asciiOffset + this.scoreMax);
    }

    public char getCharMaxExpected() {
        return (char)(this.asciiOffset + this.scoreMaxExpected);
    }

    public boolean isCharValid(char c) {
        return c >= this.getCharMin() && c <= this.getCharMax();
    }

    public int findInvalidChar(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (this.isCharValid(c)) continue;
            return c;
        }
        return -1;
    }

    public int getScore(char character) {
        return character - this.asciiOffset;
    }

    public double getProbability(char character) {
        return this.convertScoreToProbability(character - this.asciiOffset);
    }

    public double convertScoreToProbability(int score) {
        if (this.phredScore) {
            return Math.pow(10.0, (double)score / -10.0);
        }
        return 1.0 / (1.0 / Math.pow(10.0, (double)(-score) / 10.0) + 1.0);
    }

    public double convertProbabilityToScore(double p) {
        if (this.phredScore) {
            return -10.0 * Math.log10(p);
        }
        return -10.0 * Math.log10(p / (1.0 - p));
    }

    public static double convertSolexaScoreToPhredScore(int solexaScore) {
        if (solexaScore < -5) {
            throw new IllegalArgumentException("Invalid Solexa quality: " + solexaScore);
        }
        return 10.0 * Math.log10(Math.pow(10.0, (double)solexaScore / 10.0) + 1.0);
    }

    public static double convertPhredSCoreToSolexaScore(int phredScore) {
        if (phredScore == 0) {
            return -5.0;
        }
        if (phredScore > 0) {
            return Math.max(-5.0, 10.0 * Math.log10(Math.pow(10.0, (double)phredScore / 10.0) - 1.0));
        }
        throw new IllegalArgumentException("Invalid PHRED quality: " + phredScore);
    }

    public String convertTo(String quality, FastqFormat format) {
        if (quality == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(quality.length());
        for (char c : quality.toCharArray()) {
            sb.append(this.convertTo(c, format));
        }
        return sb.toString();
    }

    public char convertTo(char character, FastqFormat format) {
        return (char)(format.asciiOffset + this.convertScoreTo(this.getScore(character), format));
    }

    public int convertScoreTo(int score, FastqFormat format) {
        if (this.isPhredScore() != format.isPhredScore()) {
            if (this.isPhredScore()) {
                return (int)Math.round(FastqFormat.convertPhredSCoreToSolexaScore(score));
            }
            return (int)Math.round(FastqFormat.convertSolexaScoreToPhredScore(score));
        }
        return score;
    }

    public static FastqFormat getFormatFromName(String name) {
        if (name == null) {
            return null;
        }
        String lowerName = name.toLowerCase().trim();
        for (FastqFormat format : FastqFormat.values()) {
            if (format.getName().toLowerCase().equals(lowerName)) {
                return format;
            }
            if (format.alias == null || !format.alias.contains(lowerName)) continue;
            return format;
        }
        return null;
    }

    public static FastqFormat identifyFormat(InputStream is) throws IOException, BadBioEntryException {
        return FastqFormat.identifyFormat(is, -1);
    }

    public static FastqFormat identifyFormat(InputStream is, int maxEntriesToRead) throws IOException, BadBioEntryException {
        if (is == null) {
            throw new NullPointerException("The input format is null");
        }
        FastqReader reader = new FastqReader(is);
        HashSet<FastqFormat> formats = new HashSet<FastqFormat>(Arrays.asList(FastqFormat.values()));
        int count = 0;
        int[] range = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (ReadSequence read : reader) {
            if (maxEntriesToRead > 0 && count > maxEntriesToRead) break;
            FastqFormat.removeBadFormats(formats, read.getQuality(), range);
            ++count;
        }
        reader.throwException();
        reader.close();
        return FastqFormat.identifyFormatByHeuristic(formats, range[0], range[1]);
    }

    public static FastqFormat identifyFormat(String qualityString) {
        if (qualityString == null) {
            return null;
        }
        HashSet<FastqFormat> formats = new HashSet<FastqFormat>(Arrays.asList(FastqFormat.values()));
        int[] range = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        FastqFormat.removeBadFormats(formats, qualityString, range);
        return FastqFormat.identifyFormatByHeuristic(formats, range[0], range[1]);
    }

    private static void removeBadFormats(Set<FastqFormat> formats, String qualityString, int[] range) {
        HashSet<FastqFormat> toRemove = null;
        for (FastqFormat format : formats) {
            for (int i = 0; i < qualityString.length(); ++i) {
                int c = qualityString.codePointAt(i);
                if (c < range[0]) {
                    range[0] = c;
                }
                if (c > range[1]) {
                    range[1] = c;
                }
                if (c >= format.getCharMin() && c <= format.getCharMax()) continue;
                if (toRemove == null) {
                    toRemove = new HashSet<FastqFormat>();
                }
                toRemove.add(format);
            }
        }
        if (toRemove != null) {
            formats.removeAll(toRemove);
        }
    }

    private static FastqFormat identifyFormatByHeuristic(Set<FastqFormat> formats, int lowerChar, int higherChar) {
        if (formats == null) {
            return null;
        }
        if (formats.isEmpty()) {
            return null;
        }
        ArrayList<FastqFormat> sortedFormats = new ArrayList<FastqFormat>(formats);
        sortedFormats.sort(Comparator.comparingInt(FastqFormat::getCharMin));
        FastqFormat last = null;
        for (FastqFormat f : sortedFormats) {
            if (last != null && last.getCharMin() <= lowerChar && lowerChar < f.getCharMin()) {
                return f;
            }
            last = f;
        }
        if (higherChar <= last.getCharMax()) {
            return last;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    private FastqFormat(String name, String[] alias, String illuminaVersion, int scoreMin, int scoreMax, int scoreMaxExpected, int asciiOffset, boolean phredQualityScore) {
        this.name = name;
        this.alias = alias == null ? null : new HashSet<String>(Arrays.asList(alias));
        this.illuminaVersion = illuminaVersion;
        this.scoreMin = scoreMin;
        this.scoreMax = scoreMax;
        this.scoreMaxExpected = scoreMaxExpected;
        this.asciiOffset = asciiOffset;
        this.phredScore = phredQualityScore;
    }
}

