/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.Alphabet;
import fr.ens.biologie.genomique.kenetre.bio.Alphabets;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.io.FastaLineParser;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.io.UnSynchronizedBufferedWriter;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GenomeDescription {
    private static final String PREFIX = "genome.";
    private static final String NAME_PREFIX = "genome.name";
    private static final String LENGTH_PREFIX = "genome.length";
    private static final String MD5_PREFIX = "genome.md5";
    private static final String SEQUENCE_PREFIX = "genome.sequence.";
    private static final String SEQUENCES_COUNT_PREFIX = "genome.sequences";
    private String genomeName;
    private final Map<String, Long> sequences = new LinkedHashMap<String, Long>();
    private String md5Sum;

    private void setGenomeName(String genomeName) {
        this.genomeName = genomeName;
    }

    public void addSequence(String sequenceName, long sequenceLength) {
        this.sequences.put(sequenceName, sequenceLength);
    }

    public void setMD5Sum(String md5Digest) {
        this.md5Sum = md5Digest;
    }

    public String getGenomeName() {
        return this.genomeName;
    }

    public long getSequenceLength(String sequenceName) {
        if (this.sequences.containsKey(sequenceName)) {
            return this.sequences.get(sequenceName);
        }
        return -1L;
    }

    public boolean containsSequence(String sequenceName) {
        return this.sequences.containsKey(sequenceName);
    }

    public List<String> getSequencesNames() {
        return Collections.unmodifiableList(Utils.newArrayList(this.sequences.keySet()));
    }

    public String getMD5Sum() {
        return this.md5Sum;
    }

    public int getSequenceCount() {
        return this.sequences.size();
    }

    public long getGenomeLength() {
        long count = 0L;
        for (Map.Entry<String, Long> e : this.sequences.entrySet()) {
            count += e.getValue().longValue();
        }
        return count;
    }

    public void save(OutputStream os) throws IOException {
        Objects.requireNonNull(os, "OutputStream is null");
        UnSynchronizedBufferedWriter writer = FileUtils.createFastBufferedWriter((OutputStream)os);
        if (this.genomeName != null) {
            writer.write("genome.name=" + this.getGenomeName() + '\n');
        }
        if (this.md5Sum != null) {
            writer.write("genome.md5=" + this.getMD5Sum() + '\n');
        }
        writer.write("genome.sequences=" + this.getSequenceCount() + '\n');
        writer.write("genome.length=" + this.getGenomeLength() + '\n');
        for (String seqName : this.getSequencesNames()) {
            writer.write(SEQUENCE_PREFIX + seqName + "=" + this.getSequenceLength(seqName) + "\n");
        }
        writer.close();
    }

    public void save(File file) throws IOException {
        Objects.requireNonNull(file, "File is null");
        this.save(FileUtils.createOutputStream((File)file));
    }

    public static GenomeDescription load(InputStream is) throws IOException {
        Objects.requireNonNull(is, "InputStream is null");
        GenomeDescription result = new GenomeDescription();
        BufferedReader read = FileUtils.createBufferedReader((InputStream)is);
        String line = null;
        while ((line = read.readLine()) != null) {
            List<String> fields = Arrays.asList(line.split("="));
            if (fields.size() <= 1) continue;
            String key = fields.get(0).trim();
            if (key.startsWith(NAME_PREFIX)) {
                result.setGenomeName(fields.get(1));
            }
            if (key.startsWith(MD5_PREFIX)) {
                result.setMD5Sum(fields.get(1));
                continue;
            }
            try {
                if (!key.startsWith(SEQUENCE_PREFIX)) continue;
                result.addSequence(key.substring(SEQUENCE_PREFIX.length()), Integer.parseInt(fields.get(1)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        is.close();
        return result;
    }

    public static GenomeDescription load(File file) throws IOException {
        Objects.requireNonNull(file, "File is null");
        return GenomeDescription.load(FileUtils.createInputStream((File)file));
    }

    public static GenomeDescription createGenomeDescFromFasta(File genomeFastaFile) throws BadBioEntryException, IOException {
        Objects.requireNonNull(genomeFastaFile, "The genome file is null");
        return GenomeDescription.createGenomeDescFromFasta(FileUtils.createInputStream((File)genomeFastaFile), genomeFastaFile.getName());
    }

    public static GenomeDescription createGenomeDescFromFasta(InputStream genomeFastaIs, String filename) throws BadBioEntryException, IOException {
        return GenomeDescription.createGenomeDesc(genomeFastaIs, filename, false);
    }

    public static GenomeDescription createGenomeDescFromGFF(File gffFile) throws BadBioEntryException, IOException {
        Objects.requireNonNull(gffFile, "The genome file is null");
        return GenomeDescription.createGenomeDescFromGFF(FileUtils.createInputStream((File)gffFile), gffFile.getName());
    }

    public static GenomeDescription createGenomeDescFromGFF(InputStream gffFile, String filename) throws BadBioEntryException, IOException {
        return GenomeDescription.createGenomeDesc(gffFile, filename, true);
    }

    public static GenomeDescription createGenomeDesc(InputStream genomeFastaIs, String filename, boolean gffFormat) throws BadBioEntryException, IOException {
        MessageDigest md5Digest;
        Objects.requireNonNull(genomeFastaIs, "The input stream of the genome is null");
        GenomeDescription result = new GenomeDescription();
        result.setGenomeName(StringUtils.basename((String)filename));
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            md5Digest = null;
        }
        FastaLineParser parser = new FastaLineParser(genomeFastaIs, gffFormat);
        Alphabet alphabet = Alphabets.AMBIGUOUS_DNA_ALPHABET;
        String seqName = null;
        String lastSeqName = null;
        String parsedSeqName = null;
        long chrSize = 0L;
        while ((seqName = parser.parseNextLineAndGetSequenceName()) != null) {
            String sequence;
            if (!seqName.equals(lastSeqName)) {
                if (result.getSequenceLength(lastSeqName) != -1L) {
                    throw new BadBioEntryException("Sequence name found twice: " + lastSeqName, lastSeqName);
                }
                if (lastSeqName != null) {
                    result.addSequence(parsedSeqName, chrSize);
                }
                if ((parsedSeqName = GenomeDescription.parseChromosomeName(seqName)) == null) {
                    throw new IOException("No fasta header found.");
                }
                if (md5Digest != null) {
                    md5Digest.update(parsedSeqName.getBytes(Charset.defaultCharset()));
                }
                lastSeqName = seqName;
                chrSize = 0L;
            }
            if ((sequence = parser.getSequence()) == null) {
                throw new IOException("No fasta sequence found.");
            }
            chrSize += GenomeDescription.checkBases(sequence, lastSeqName, alphabet);
            md5Digest.update(sequence.getBytes(Charset.defaultCharset()));
        }
        if (lastSeqName != null) {
            result.addSequence(parsedSeqName, chrSize);
        }
        if (md5Digest != null) {
            result.setMD5Sum(StringUtils.md5DigestToString((MessageDigest)md5Digest));
        }
        genomeFastaIs.close();
        return result;
    }

    private static String parseChromosomeName(String fastaHeader) throws BadBioEntryException {
        if (fastaHeader == null) {
            return null;
        }
        if ("".equals(fastaHeader.trim())) {
            throw new BadBioEntryException("Sequence header is empty", ">" + fastaHeader);
        }
        if (fastaHeader.startsWith(" ")) {
            throw new BadBioEntryException("A whitespace was found at the beginning of the sequence name", ">" + fastaHeader);
        }
        String s = fastaHeader.trim();
        String[] fields = s.split("\\s");
        if (fields == null || fields.length == 0) {
            throw new BadBioEntryException("Invalid sequence header", ">" + fastaHeader);
        }
        return fields[0];
    }

    private static long checkBases(String sequence, String sequenceName, Alphabet alphabet) throws BadBioEntryException {
        char[] array;
        for (char c : array = sequence.toCharArray()) {
            if (alphabet.isLetterValid(c)) continue;
            throw new BadBioEntryException("Invalid base in genome: " + c, sequenceName);
        }
        return sequence.length();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{genomeName=" + this.genomeName + ", sequencesCount=" + this.sequences.size() + ", md5Sum=" + this.md5Sum + ", sequences=" + this.sequences + "}";
    }
}

