/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.GFFEntry;
import java.io.Serializable;
import java.util.Objects;

public class GenomicInterval
implements Serializable,
Comparable<GenomicInterval> {
    private static final long serialVersionUID = 1974207984076778441L;
    private final String chromosome;
    private final int start;
    private final int end;
    private final char strand;

    public String getChromosome() {
        return this.chromosome;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public char getStrand() {
        return this.strand;
    }

    public int getLength() {
        return this.end - this.start + 1;
    }

    public final boolean include(int start, int end) {
        return Math.min(start, end) >= this.start && Math.max(start, end) <= this.end;
    }

    public final boolean intersect(int start, int end) {
        int minStart = Math.min(start, end);
        int maxEnd = Math.max(start, end);
        return minStart >= this.start && minStart <= this.end || maxEnd >= this.start && maxEnd <= this.end || minStart < this.start && maxEnd > this.end;
    }

    public final boolean intersect(GenomicInterval interval) {
        if (interval == null || !this.chromosome.equals(interval.chromosome)) {
            return false;
        }
        if (this.strand != interval.strand && this.strand != '.' && interval.strand != '.') {
            return false;
        }
        return this.intersect(interval.getStart(), interval.getEnd());
    }

    public final int intersectLength(int start, int end) {
        if (!this.intersect(start, end)) {
            return 0;
        }
        return Math.min(this.end, Math.max(start, end)) - Math.max(this.start, Math.min(start, end)) + 1;
    }

    public final int intersectLength(GenomicInterval interval) {
        if (interval == null || !this.intersect(interval)) {
            return 0;
        }
        return this.intersectLength(interval.getStart(), interval.getEnd());
    }

    @Override
    public int compareTo(GenomicInterval e) {
        if (e == null) {
            return -1;
        }
        if (!this.getChromosome().equals(e.getChromosome())) {
            return this.getChromosome().compareTo(e.getChromosome());
        }
        int startComp = Integer.compare(this.start, e.getStart());
        if (startComp != 0) {
            return startComp;
        }
        return Integer.compare(this.end, e.getEnd());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenomicInterval)) {
            return false;
        }
        GenomicInterval that = (GenomicInterval)o;
        return Objects.equals(this.chromosome, that.chromosome) && this.start == that.start && this.end == that.end && this.strand == that.strand;
    }

    public int hashCode() {
        return Objects.hash(this.chromosome, this.start, this.end, Character.valueOf(this.strand));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.chromosome + " [" + this.start + "-" + this.end + "]" + this.strand + "}";
    }

    public GenomicInterval(String chromosome, int start, int end, char strand) {
        if (chromosome == null) {
            throw new NullPointerException("The chromosome value is null");
        }
        if (start < 1) {
            throw new IllegalArgumentException("Start position is lower than 1: " + start);
        }
        if (end < start) {
            throw new IllegalArgumentException("Start position is greater than end: " + end);
        }
        if (strand != '+' && strand != '-' && strand != '.') {
            throw new IllegalArgumentException("Invalid strand value: " + strand);
        }
        this.chromosome = chromosome;
        this.start = start;
        this.end = end;
        this.strand = strand;
    }

    public GenomicInterval(GFFEntry gffEntry) {
        this(gffEntry, true);
    }

    public GenomicInterval(GFFEntry gffEntry, boolean saveStrandInfo) {
        this(gffEntry.getSeqId(), gffEntry.getStart(), gffEntry.getEnd(), saveStrandInfo ? (char)gffEntry.getStrand() : (char)'.');
    }
}

