/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import htsjdk.samtools.SAMRecord;
import java.io.Serializable;
import java.util.Comparator;

public class SAMComparator
implements Comparator<SAMRecord>,
Serializable {
    private static final long serialVersionUID = -3948514532737476599L;

    @Override
    public int compare(SAMRecord r0, SAMRecord r1) {
        if (r0 == null) {
            throw new NullPointerException("r0 argument is null in SAMComparator");
        }
        if (r1 == null) {
            throw new NullPointerException("r1 argument is null in SAMComparator");
        }
        int comp = r0.getReadName().compareTo(r1.getReadName());
        if (comp == 0 && (comp = r0.getMappingQuality() - r1.getMappingQuality()) == 0 && (comp = r0.getReferenceName().compareTo(r1.getReferenceName())) == 0) {
            if (r0.getReadPairedFlag()) {
                if (r0.getAlignmentStart() == r1.getMateAlignmentStart() && r1.getAlignmentStart() == r0.getMateAlignmentStart()) {
                    comp = r0.getFlags() - r1.getFlags();
                } else {
                    if (r0.getFirstOfPairFlag() && r1.getFirstOfPairFlag()) {
                        comp = r0.getAlignmentStart() - r1.getAlignmentStart();
                        if (comp == 0) {
                            comp = r0.getMateAlignmentStart() - r1.getMateAlignmentStart();
                        }
                    } else if (!r0.getFirstOfPairFlag() && !r1.getFirstOfPairFlag()) {
                        comp = r0.getMateAlignmentStart() - r1.getMateAlignmentStart();
                        if (comp == 0) {
                            comp = r0.getAlignmentStart() - r1.getAlignmentStart();
                        }
                    } else if (r0.getFirstOfPairFlag() && !r1.getFirstOfPairFlag()) {
                        comp = r0.getAlignmentStart() - r1.getMateAlignmentStart();
                        if (comp == 0) {
                            comp = r0.getMateAlignmentStart() - r1.getAlignmentStart();
                        }
                    } else {
                        comp = r0.getMateAlignmentStart() - r1.getAlignmentStart();
                        if (comp == 0) {
                            comp = r0.getAlignmentStart() - r1.getMateAlignmentStart();
                        }
                    }
                    if (comp == 0) {
                        comp = r0.getCigarString().compareTo(r1.getCigarString());
                    }
                }
            } else {
                comp = r0.getAlignmentStart() - r1.getAlignmentStart();
                if (comp == 0 && (comp = r0.getAlignmentEnd() - r1.getAlignmentEnd()) == 0) {
                    comp = r0.getCigarString().compareTo(r1.getCigarString());
                }
            }
        }
        return comp;
    }
}

