/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.BEDEntry;
import fr.ens.biologie.genomique.kenetre.bio.EntryMetadata;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.GenomicInterval;
import fr.ens.biologie.genomique.kenetre.bio.StrandUsage;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SAMUtils {
    public static String readSAMHeader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("The file is null");
        }
        return SAMUtils.readSAMHeader(new FileInputStream(file));
    }

    public static String readSAMHeader(InputStream is) {
        if (is == null) {
            throw new NullPointerException("The input stream is null.");
        }
        SamReader reader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)is));
        SAMFileHeader header = reader.getFileHeader();
        StringWriter headerTextBuffer = new StringWriter();
        new SAMTextHeaderCodec().encode((Writer)headerTextBuffer, header);
        return headerTextBuffer.toString();
    }

    public static GenomeDescription createGenomeDescriptionFromSAM(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("The file is null");
        }
        return SAMUtils.createGenomeDescriptionFromSAM(new FileInputStream(file));
    }

    public static GenomeDescription createGenomeDescriptionFromSAM(InputStream is) {
        return SAMUtils.createGenomeDescriptionFromSAM(SAMUtils.readSAMHeader(is));
    }

    public static GenomeDescription createGenomeDescriptionFromSAM(String header) {
        if (header == null) {
            return null;
        }
        GenomeDescription desc = new GenomeDescription();
        String prefix = "@SQ\tSN:";
        for (String line : header.split("\n")) {
            String[] fields;
            if (!line.startsWith("@SQ\tSN:") || (fields = line.substring("@SQ\tSN:".length()).split("\tLN:")).length != 2) continue;
            desc.addSequence(fields[0], Integer.parseInt(fields[1]));
        }
        return desc;
    }

    public static GenomeDescription createGenomeDescriptionFromSAM(SAMFileHeader header) {
        if (header == null) {
            return null;
        }
        GenomeDescription desc = new GenomeDescription();
        if (header.getSequenceDictionary() == null) {
            return desc;
        }
        for (SAMSequenceRecord seq : header.getSequenceDictionary().getSequences()) {
            desc.addSequence(seq.getSequenceName(), seq.getSequenceLength());
        }
        return desc;
    }

    public static GenomeDescription createGenomeDescriptionFromSAM(SAMRecord samRecord) {
        if (samRecord == null) {
            return null;
        }
        return SAMUtils.createGenomeDescriptionFromSAM(samRecord.getHeader());
    }

    public static SAMSequenceDictionary newSAMSequenceDictionary(GenomeDescription genomeDescription) {
        if (genomeDescription == null) {
            throw new NullPointerException("The genome description is null.");
        }
        ArrayList<SAMSequenceRecord> sequences = new ArrayList<SAMSequenceRecord>();
        for (String sequenceName : genomeDescription.getSequencesNames()) {
            SAMSequenceRecord sequenceRecord = new SAMSequenceRecord(sequenceName, (int)genomeDescription.getSequenceLength(sequenceName));
            sequences.add(sequenceRecord);
        }
        return new SAMSequenceDictionary(sequences);
    }

    public static SAMFileHeader newSAMFileHeader(GenomeDescription genomeDescription) {
        SAMFileHeader header = new SAMFileHeader();
        header.setSequenceDictionary(SAMUtils.newSAMSequenceDictionary(genomeDescription));
        return header;
    }

    public static BEDEntry parseIntervalsToBEDEntry(SAMRecord record) {
        return SAMUtils.parseIntervalsToBEDEntry(record, null);
    }

    public static BEDEntry parseIntervalsToBEDEntry(SAMRecord record, EntryMetadata metadata) {
        Objects.requireNonNull(record, "record argument canot be null");
        BEDEntry result = metadata == null ? new BEDEntry() : new BEDEntry(metadata);
        result.setChromosomeName(record.getReferenceName());
        result.setStart(record.getAlignmentStart());
        result.setEnd(record.getAlignmentEnd());
        result.setName(record.getReadName());
        result.setThickStart(record.getAlignmentStart());
        result.setThickEnd(record.getAlignmentEnd());
        if (!record.getReadUnmappedFlag()) {
            result.setStrand(record.getReadNegativeStrandFlag() ? (char)'-' : '+');
        }
        for (GenomicInterval gi : SAMUtils.parseIntervals(record)) {
            result.addBlock(gi.getStart(), gi.getEnd());
        }
        return result;
    }

    public static List<GenomicInterval> parseIntervals(SAMRecord record, StrandUsage stranded) {
        Objects.requireNonNull(record, "record argument canot be null");
        Objects.requireNonNull(stranded, "stranded argument canot be null");
        char strand = stranded == StrandUsage.REVERSE ? (record.getReadNegativeStrandFlag() ? (char)'+' : '-') : (record.getReadNegativeStrandFlag() ? (char)'-' : '+');
        return SAMUtils.parseIntervals(record, strand);
    }

    public static List<GenomicInterval> parseIntervals(SAMRecord record) {
        Objects.requireNonNull(record, "record argument canot be null");
        return SAMUtils.parseIntervals(record, record.getReadNegativeStrandFlag() ? (char)'-' : '+');
    }

    public static List<GenomicInterval> parseIntervals(SAMRecord record, char strand) {
        Objects.requireNonNull(record, "record argument canot be null");
        if (strand != '+' && strand != '-' && strand != '.') {
            throw new IllegalArgumentException("invalid strand argument: " + strand);
        }
        ArrayList<GenomicInterval> result = new ArrayList<GenomicInterval>();
        int end = record.getAlignmentStart();
        int start = record.getAlignmentStart();
        for (CigarElement e : record.getCigar().getCigarElements()) {
            switch (e.getOperator()) {
                case M: 
                case D: {
                    end += e.getLength();
                    break;
                }
                case N: {
                    result.add(new GenomicInterval(record.getReferenceName(), start, end, strand));
                    start = end += e.getLength();
                    break;
                }
            }
        }
        result.add(new GenomicInterval(record.getReferenceName(), start, end, strand));
        return result;
    }
}

