/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.alignmentfilter;

import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.AbstractReadAlignmentFilter;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRemoveFlagReadAlignmentFilter
extends AbstractReadAlignmentFilter {
    public static final String FILTER_NAME = "removetest";
    private final List<SAMRecord> recordsToRemove = new ArrayList<SAMRecord>();
    private final int flagValue;

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Remove all the unmapped alignments";
    }

    private boolean isFlagEnabled(int flags) {
        return (flags & this.flagValue) != 0;
    }

    @Override
    public void filterReadAlignments(List<SAMRecord> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        if (!records.get(0).getReadPairedFlag()) {
            for (SAMRecord r : records) {
                if (!this.isFlagEnabled(r.getFlags())) continue;
                this.recordsToRemove.add(r);
            }
        } else {
            for (int counterRecord = 0; counterRecord < records.size() - 1; counterRecord += 2) {
                if (!this.isFlagEnabled(records.get(counterRecord).getFlags()) && !this.isFlagEnabled(records.get(counterRecord + 1).getFlags())) continue;
                this.recordsToRemove.add(records.get(counterRecord));
                this.recordsToRemove.add(records.get(counterRecord + 1));
            }
        }
        records.removeAll(this.recordsToRemove);
        this.recordsToRemove.clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + "}";
    }

    protected AbstractRemoveFlagReadAlignmentFilter(int flagValue) {
        this.flagValue = flagValue;
    }
}

