/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.alignmentfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.AbstractReadAlignmentFilter;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.List;

public class DistanceFromReferenceReadAlignmentFilter
extends AbstractReadAlignmentFilter {
    public static final String FILTER_NAME = "distancefromreference";
    private int distance = -1;

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "After this filter, only the alignments which the distance from the reference is lower than the given distance are kept.";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("threshold".equals(key.trim())) {
            try {
                this.distance = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                return;
            }
            if (this.distance < 0) {
                throw new KenetreException("Invalid distance: " + this.distance);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " alignments filter: " + key);
        }
    }

    @Override
    public void init() {
        if (this.distance < 0) {
            throw new IllegalArgumentException("The distance from the reference is not set for " + this.getName() + " alignments filter.");
        }
    }

    @Override
    public void filterReadAlignments(List<SAMRecord> records) {
        if (records == null) {
            return;
        }
        ArrayList<SAMRecord> recordsToKeep = new ArrayList<SAMRecord>();
        if (!records.get(0).getReadPairedFlag()) {
            for (SAMRecord r : records) {
                if (r.getCigarString().contains("S") || r.getCigarString().contains("H") || r.getAttribute("NM") == null || r.getIntegerAttribute("NM") > this.distance) continue;
                recordsToKeep.add(r);
            }
        } else {
            for (int counterRecord = 0; counterRecord < records.size() - 1; counterRecord += 2) {
                SAMRecord r1 = records.get(counterRecord);
                SAMRecord r2 = records.get(counterRecord + 1);
                if (r1.getCigarString().contains("S") || r1.getCigarString().contains("H") || r1.getAttribute("NM") == null || r1.getIntegerAttribute("NM") > this.distance || r2.getCigarString().contains("S") || r2.getCigarString().contains("H") || r2.getAttribute("NM") == null || r2.getIntegerAttribute("NM") > this.distance) continue;
                recordsToKeep.add(r1);
                recordsToKeep.add(r2);
            }
        }
        records.clear();
        records.addAll(recordsToKeep);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + ", distance=" + this.distance + "}";
    }
}

