/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.alignmentfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.AbstractReadAlignmentFilter;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.List;

public class KeepNumberMatchReadAlignmentFilter
extends AbstractReadAlignmentFilter {
    public static final String FILTER_NAME = "keepnumbermatch";
    private int numberMatch = -1;

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "This filter allows to keep a given number of alignments of a read.";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("threshold".equals(key.trim())) {
            try {
                this.numberMatch = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                return;
            }
            if (this.numberMatch < 0) {
                throw new KenetreException("Invalid number of match to keep: " + this.numberMatch);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " alignments filter: " + key);
        }
    }

    @Override
    public void init() {
        if (this.numberMatch < 0) {
            throw new IllegalArgumentException("The number of match to keep is not set for " + this.getName() + " alignments filter.");
        }
    }

    @Override
    public void filterReadAlignments(List<SAMRecord> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        ArrayList<SAMRecord> recordsToKeep = new ArrayList<SAMRecord>();
        int nbRecordsToKeep = !records.get(0).getReadPairedFlag() ? this.numberMatch : this.numberMatch * 2;
        if (records.size() > nbRecordsToKeep) {
            for (int cptRecords = 0; cptRecords < nbRecordsToKeep; ++cptRecords) {
                recordsToKeep.add(records.get(cptRecords));
            }
            records.clear();
            records.addAll(recordsToKeep);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + ", numberMatch=" + this.numberMatch + "}";
    }
}

