/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.alignmentfilter;

import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.ReadAlignmentFilter;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MultiReadAlignmentFilter
implements ReadAlignmentFilter {
    private GenericLogger logger = new DummyLogger();
    private final List<ReadAlignmentFilter> list = new ArrayList<ReadAlignmentFilter>();
    private final ReporterIncrementer incrementer;
    private final String counterGroup;

    @Override
    public void filterReadAlignments(List<SAMRecord> records) {
        boolean pairedEnd = false;
        if (records == null || records.isEmpty()) {
            return;
        }
        if (records.get(0).getReadPairedFlag()) {
            pairedEnd = true;
        }
        for (ReadAlignmentFilter af : this.list) {
            int sizeBefore = records.size();
            af.filterReadAlignments(records);
            int sizeAfter = records.size();
            int diff = sizeBefore - sizeAfter;
            if (diff > 0 && this.incrementer != null) {
                if (pairedEnd) {
                    this.incrementer.incrCounter(this.counterGroup, "alignments rejected by " + af.getName() + " filter", (long)(diff / 2));
                } else {
                    this.incrementer.incrCounter(this.counterGroup, "alignments rejected by " + af.getName() + " filter", (long)diff);
                }
            }
            if (sizeAfter != 0) continue;
            return;
        }
    }

    public void addFilter(ReadAlignmentFilter filter) {
        if (filter != null) {
            this.list.add(filter);
        }
    }

    @Override
    public String getName() {
        return "MultiAlignmentsFilter";
    }

    @Override
    public String getDescription() {
        return "Multi alignments filter";
    }

    @Override
    public void setParameter(String key, String value) {
    }

    @Override
    public void setLogger(GenericLogger logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
    }

    @Override
    public GenericLogger getLogger() {
        return this.logger;
    }

    @Override
    public void init() {
    }

    public List<String> getFilterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ReadAlignmentFilter f : this.list) {
            result.add(f.getName());
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{incrementer=" + this.incrementer + ",counterGroup=" + this.counterGroup + " , list=" + this.list + "}";
    }

    public MultiReadAlignmentFilter() {
        this(null, null);
    }

    public MultiReadAlignmentFilter(ReporterIncrementer incrementer, String counterGroup) {
        this.incrementer = incrementer;
        this.counterGroup = counterGroup;
    }

    public MultiReadAlignmentFilter(List<ReadAlignmentFilter> filters) {
        this(null, null, filters);
    }

    public MultiReadAlignmentFilter(ReporterIncrementer incrementer, String counterGroup, List<ReadAlignmentFilter> filters) {
        this.incrementer = incrementer;
        this.counterGroup = counterGroup;
        if (filters != null) {
            for (ReadAlignmentFilter filter : filters) {
                this.addFilter(filter);
            }
        }
    }
}

