/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.alignmentfilter;

import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.ReadAlignmentFilter;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.List;

public class ReadAlignmentFilterBuffer {
    private final ReadAlignmentFilter filter;
    private final List<SAMRecord> list = new ArrayList<SAMRecord>();
    private String currentName;
    private final boolean reuseResultList;

    public boolean addAlignment(SAMRecord alignment) {
        if (alignment == null) {
            return false;
        }
        String name = ReadAlignmentFilterBuffer.parseAlignmentName(alignment);
        if (this.currentName == null) {
            this.currentName = name;
        } else if (!this.currentName.equals(name)) {
            this.currentName = null;
            return false;
        }
        this.list.add(alignment);
        return true;
    }

    public List<SAMRecord> getFilteredAlignments() {
        this.filter.filterReadAlignments(this.list);
        if (this.reuseResultList) {
            return this.list;
        }
        ArrayList<SAMRecord> results = new ArrayList<SAMRecord>(this.list);
        this.list.clear();
        this.currentName = null;
        return results;
    }

    private static String parseAlignmentName(SAMRecord alignment) {
        String alignmentName = alignment.getReadName();
        int spaceIndex = alignmentName.indexOf(32);
        if (spaceIndex == -1) {
            return alignmentName;
        }
        return alignmentName.substring(0, spaceIndex);
    }

    public ReadAlignmentFilterBuffer(ReadAlignmentFilter filter) {
        this(filter, false);
    }

    public ReadAlignmentFilterBuffer(ReadAlignmentFilter filter, boolean reuseResultList) {
        if (filter == null) {
            throw new NullPointerException("The alignment filter is null");
        }
        this.filter = filter;
        this.reuseResultList = reuseResultList;
    }
}

