/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.alignmentfilter;

import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.AbstractReadAlignmentFilter;
import htsjdk.samtools.SAMRecord;
import java.util.List;

public class RemoveMultiMatchesReadAlignmentFilter
extends AbstractReadAlignmentFilter {
    public static final String FILTER_NAME = "removemultimatches";

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Remove all the alignments with several matches";
    }

    @Override
    public void filterReadAlignments(List<SAMRecord> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        if (!records.get(0).getReadPairedFlag()) {
            if (records.size() > 1) {
                records.clear();
            }
        } else {
            switch (records.size()) {
                case 1: {
                    return;
                }
                case 2: {
                    int countFirstInPair = 0;
                    int countSecondInPair = 0;
                    for (SAMRecord record : records) {
                        if (record.getFirstOfPairFlag()) {
                            ++countFirstInPair;
                            continue;
                        }
                        if (!record.getSecondOfPairFlag()) continue;
                        ++countSecondInPair;
                    }
                    if (countFirstInPair <= 1 && countSecondInPair <= true) break;
                    records.clear();
                    break;
                }
                default: {
                    records.clear();
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + "}";
    }
}

