/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.BEDEntry;
import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class BEDWriter
implements Closeable {
    public static final int DEFAULT_FORMAT = 12;
    private final Writer writer;
    private final int format;
    private boolean first = true;

    private void writeMetadata(BEDEntry entry) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> e : entry.getMetadata().entries().entrySet()) {
            for (String v : e.getValue()) {
                sb.append(e.getKey());
                sb.append(' ');
                sb.append(v);
                sb.append('\n');
            }
        }
        this.writer.write(sb.toString());
    }

    public void write(BEDEntry entry) throws IOException {
        if (entry == null) {
            return;
        }
        if (this.first) {
            this.writeMetadata(entry);
            this.first = false;
        }
        this.writer.write(entry.toBED(this.format) + '\n');
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public BEDWriter(Writer writer, int format) {
        if (writer == null) {
            throw new NullPointerException("The writer is null.");
        }
        BEDEntry.checkBEDFieldCount(format);
        this.writer = writer;
        this.format = format;
    }

    public BEDWriter(OutputStream os, int format) throws FileNotFoundException {
        BEDEntry.checkBEDFieldCount(format);
        this.writer = FileUtils.createFastBufferedWriter((OutputStream)os, (Charset)BioCharsets.BED_CHARSET);
        this.format = format;
    }

    public BEDWriter(File outputFile, int format) throws IOException {
        BEDEntry.checkBEDFieldCount(format);
        this.writer = FileUtils.createFastBufferedWriter((File)outputFile, (Charset)BioCharsets.BED_CHARSET);
        this.format = format;
    }

    public BEDWriter(String outputFilename, int format) throws IOException {
        BEDEntry.checkBEDFieldCount(format);
        this.writer = FileUtils.createFastBufferedWriter((String)outputFilename, (Charset)BioCharsets.BED_CHARSET);
        this.format = format;
    }

    public BEDWriter(Writer writer) {
        this(writer, 12);
    }

    public BEDWriter(OutputStream os) throws FileNotFoundException {
        this(os, 12);
    }

    public BEDWriter(File outputFile) throws IOException {
        this(outputFile, 12);
    }

    public BEDWriter(String outputFilename) throws IOException {
        this(outputFilename, 12);
    }
}

