/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.AnnotationMatrix;
import fr.ens.biologie.genomique.kenetre.bio.ExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.CellRangerExpressionMatrixReader;
import fr.ens.biologie.genomique.kenetre.bio.io.MarketMatrixExpressionMatrixWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;

public class CellRangerExpressionMatrixWriter
extends MarketMatrixExpressionMatrixWriter {
    public static final String DEFAULT_FEATURE_TYPE = "Gene Expression";
    private File barcodesFile;
    private File featuresFile;
    private Map<String, String> geneAliases;
    private final String featureType;

    @Override
    public void write(ExpressionMatrix matrix, Collection<String> rowNamesToWrite) throws IOException {
        super.write(matrix, rowNamesToWrite);
        this.writeBarcodes(matrix);
        this.writeFeatures(matrix, rowNamesToWrite);
    }

    private void writeBarcodes(ExpressionMatrix matrix) throws IOException {
        try (Writer writer = CellRangerExpressionMatrixWriter.createWriter(this.barcodesFile);){
            for (String barcode : matrix.getColumnNames()) {
                writer.write(barcode + '\n');
            }
        }
    }

    private void writeFeatures(ExpressionMatrix matrix, Collection<String> rowNamesToWrite) throws IOException {
        try (Writer writer = CellRangerExpressionMatrixWriter.createWriter(this.featuresFile);){
            for (String geneName : matrix.getRowNames()) {
                if (!rowNamesToWrite.contains(geneName)) continue;
                String alias = this.geneAliases.get(geneName);
                writer.write(geneName + '\t' + (alias == null ? "" : alias) + (this.featureType != null ? "\t" + this.featureType : "") + '\n');
            }
        }
    }

    private static Map<String, String> extractGeneAliases(AnnotationMatrix annotation, String geneAliasesField) throws IOException {
        Objects.requireNonNull(annotation, "annotation parameter cannot be null");
        Objects.requireNonNull(geneAliasesField, "geneAliasesField parameter cannot be null");
        if (!annotation.containsColumn(geneAliasesField)) {
            throw new IOException("Unknown field in annotation: " + geneAliasesField);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : annotation.getRowNames()) {
            result.put(key, (String)annotation.getValue(key, geneAliasesField));
        }
        return result;
    }

    private static Writer createWriter(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            return new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(file)));
        }
        return new FileWriter(file);
    }

    public CellRangerExpressionMatrixWriter(File directory) throws IOException {
        this(directory, 1);
    }

    public CellRangerExpressionMatrixWriter(File directory, AnnotationMatrix annotation, String annotationField) throws IOException {
        this(directory, annotation, annotationField, 1);
    }

    public CellRangerExpressionMatrixWriter(File directory, Map<String, String> geneAliases) throws IOException {
        this(directory, geneAliases, 1, null);
    }

    public CellRangerExpressionMatrixWriter(File directory, int formatVersion) throws IOException {
        this(directory, Collections.emptyMap(), formatVersion, null);
    }

    public CellRangerExpressionMatrixWriter(File directory, AnnotationMatrix annotation, String annotationField, int formatVersion) throws IOException {
        this(directory, annotation, annotationField, formatVersion, null);
    }

    public CellRangerExpressionMatrixWriter(File directory, AnnotationMatrix annotation, String annotationField, int formatVersion, String featureType) throws IOException {
        this(directory, CellRangerExpressionMatrixWriter.extractGeneAliases(annotation, annotationField), formatVersion, featureType);
    }

    public CellRangerExpressionMatrixWriter(File directory, Map<String, String> geneAliases, int formatVersion, String featureType) throws IOException {
        super(new File(directory, CellRangerExpressionMatrixReader.checkCellRangerFormatVersion(formatVersion) == 2 ? "matrix.mtx.gz" : "matrix.mtx"));
        Objects.requireNonNull(geneAliases, "geneAliases parameter cannot be null");
        this.featureType = formatVersion == 1 ? null : (featureType == null ? DEFAULT_FEATURE_TYPE : featureType.trim());
        this.featuresFile = new File(directory, formatVersion == 2 ? "features.tsv.gz" : "genes.tsv");
        this.barcodesFile = new File(directory, formatVersion == 2 ? "barcodes.tsv.gz" : "barcodes.tsv");
        this.geneAliases = geneAliases;
    }
}

