/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.io.ExpressionMatrixReader;
import fr.ens.biologie.genomique.kenetre.bio.io.MarketMatrixExpressionMatrixReader;
import fr.ens.biologie.genomique.kenetre.bio.io.SparseExpressionMatrixReader;
import fr.ens.biologie.genomique.kenetre.bio.io.TSVExpressionMatrixReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class ExpressionMatrixFormatFinderInputStream
extends InputStream {
    private InputStream is;
    private static final int CACHE_SIZE = 100000;
    private static final int MAX_LINES_TO_READ = 1;
    private MatrixFormat format;
    private boolean testFormatDone;
    private int cacheIndex;
    private byte[] cache;

    private MatrixFormat findMatrixFormat() throws IOException {
        byte[] readed = new byte[100000];
        int count = this.is.read(readed);
        if (count != 100000) {
            this.cache = new byte[count];
            System.arraycopy(readed, 0, this.cache, 0, count);
        } else {
            this.cache = readed;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.cache), Charset.defaultCharset()));){
            String line;
            int lineCount = 0;
            while ((line = reader.readLine()) != null && lineCount < 1) {
                if ("".equals(line = line.trim()) || line.startsWith("#")) continue;
                if (line.startsWith("gene\tcell\tcount")) {
                    MatrixFormat matrixFormat = MatrixFormat.SPARSE;
                    return matrixFormat;
                }
                if (line.startsWith("%%MatrixMarket ")) {
                    MatrixFormat matrixFormat = MatrixFormat.MARKET_MATRIX;
                    return matrixFormat;
                }
                if (line.startsWith("\t")) {
                    MatrixFormat matrixFormat = MatrixFormat.TSV;
                    return matrixFormat;
                }
                ++lineCount;
            }
        }
        return MatrixFormat.UNKNOWN;
    }

    public MatrixFormat getExpressionMatrixFormat() throws IOException {
        if (!this.testFormatDone) {
            this.format = this.findMatrixFormat();
        }
        return this.format;
    }

    public ExpressionMatrixReader getExpressionMatrixReader() throws IOException {
        switch (this.getExpressionMatrixFormat()) {
            case TSV: {
                return new TSVExpressionMatrixReader(this);
            }
            case SPARSE: {
                return new SparseExpressionMatrixReader(this);
            }
            case MARKET_MATRIX: {
                return new MarketMatrixExpressionMatrixReader(this);
            }
        }
        throw new IOException("Unknown Design format");
    }

    @Override
    public int read() throws IOException {
        if (this.cacheIndex == -1) {
            return -1;
        }
        if (this.cacheIndex < this.cache.length) {
            return this.cache[this.cacheIndex++];
        }
        return this.is.read();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        this.cacheIndex = -1;
    }

    public ExpressionMatrixFormatFinderInputStream(InputStream is) {
        if (is == null) {
            throw new NullPointerException("The inputStream is null");
        }
        this.is = is;
    }

    public static enum MatrixFormat {
        TSV,
        SPARSE,
        MARKET_MATRIX,
        UNKNOWN;

    }
}

