/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class FastaLineParser {
    final BufferedReader reader;
    private String seqName;
    private String sequence;
    private boolean fastaSectionFound;

    public String parseNextLineAndGetSequenceName() throws IOException {
        String line = null;
        while ((line = this.reader.readLine()) != null) {
            String trim = line.trim();
            if ("".equals(trim)) continue;
            if (!this.fastaSectionFound) {
                if (!line.startsWith("##FASTA")) continue;
                this.fastaSectionFound = true;
                continue;
            }
            if (trim.charAt(0) == '>') {
                this.seqName = trim.substring(1);
                continue;
            }
            if (this.seqName == null) {
                throw new IOException("No fasta header found at the beginning of the fasta file: " + line);
            }
            this.sequence = trim;
            return this.seqName;
        }
        return null;
    }

    public String getSequence() {
        return this.sequence;
    }

    public FastaLineParser(InputStream is) {
        this(is, false);
    }

    public FastaLineParser(InputStream is, boolean gffFile) {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.reader = new BufferedReader(new InputStreamReader(is, BioCharsets.FASTA_CHARSET));
        if (!gffFile) {
            this.fastaSectionFound = true;
        }
    }

    public FastaLineParser(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FastaLineParser(File file, boolean gffFile) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.reader = FileUtils.createBufferedReader((File)file, (Charset)BioCharsets.FASTA_CHARSET);
        if (!gffFile) {
            this.fastaSectionFound = true;
        }
    }

    public FastaLineParser(String filename) throws FileNotFoundException {
        this(filename, false);
    }

    public FastaLineParser(String filename, boolean gffFile) throws FileNotFoundException {
        this.reader = FileUtils.createBufferedReader((String)filename, (Charset)BioCharsets.FASTA_CHARSET);
        if (!gffFile) {
            this.fastaSectionFound = true;
        }
    }
}

