/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.Sequence;
import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import fr.ens.biologie.genomique.kenetre.bio.io.SequenceReader;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FastaReader
implements SequenceReader {
    protected BufferedReader reader;
    private Sequence result = new Sequence();
    private final StringBuilder sb = new StringBuilder();
    private String nextSequenceName;
    private boolean end = false;
    private boolean nextCallDone = true;
    protected IOException exception;

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Iterator<Sequence> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.end) {
            return false;
        }
        String line = null;
        try {
            while ((line = this.reader.readLine()) != null) {
                String trim = line.trim();
                if ("".equals(trim)) continue;
                if (trim.charAt(0) == '>') {
                    if (this.nextSequenceName != null) {
                        this.result = new Sequence();
                        this.result.setName(this.nextSequenceName);
                        this.result.setSequence(this.sb.toString());
                        this.sb.setLength(0);
                        this.nextSequenceName = trim.substring(1);
                        this.nextCallDone = false;
                        return true;
                    }
                    this.nextSequenceName = trim.substring(1);
                    continue;
                }
                if (this.nextSequenceName == null) {
                    throw new IOException("No fasta header found at the beginning of the fasta file: " + line);
                }
                this.sb.append(trim);
            }
            this.result.setName(this.nextSequenceName);
            this.result.setSequence(this.sb.toString());
            this.sb.setLength(0);
            this.nextCallDone = false;
            this.end = true;
            return true;
        }
        catch (IOException e) {
            this.exception = e;
            this.end = true;
            return false;
        }
    }

    @Override
    public Sequence next() {
        if (this.nextCallDone) {
            throw new NoSuchElementException();
        }
        this.nextCallDone = true;
        return this.result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void throwException() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public FastaReader(InputStream is) {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.reader = new BufferedReader(new InputStreamReader(is, BioCharsets.FASTA_CHARSET));
    }

    public FastaReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.reader = FileUtils.createBufferedReader((File)file, (Charset)BioCharsets.FASTA_CHARSET);
    }

    public FastaReader(String filename) throws FileNotFoundException {
        this.reader = FileUtils.createBufferedReader((String)filename, (Charset)BioCharsets.FASTA_CHARSET);
    }
}

