/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.Sequence;
import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import fr.ens.biologie.genomique.kenetre.bio.io.SequenceWriter;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;

public class FastaWriter
implements SequenceWriter {
    public static final int FASTA_FILE_WIDTH = 60;
    private final Writer writer;
    private final int lineLength;

    @Override
    public void write(Sequence sequence) throws IOException {
        if (sequence == null) {
            return;
        }
        this.writer.write(sequence.toFasta(this.lineLength) + '\n');
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static int checkLineLength(int lineLength) {
        if (lineLength < 1) {
            throw new IllegalArgumentException("Invalid FASTA line length: " + lineLength);
        }
        return lineLength;
    }

    public FastaWriter(Writer writer, int lineLength) {
        if (writer == null) {
            throw new NullPointerException("The writer is null.");
        }
        this.writer = writer;
        this.lineLength = FastaWriter.checkLineLength(lineLength);
    }

    public FastaWriter(OutputStream os, int lineLength) throws FileNotFoundException {
        this.writer = FileUtils.createFastBufferedWriter((OutputStream)os, (Charset)BioCharsets.FASTA_CHARSET);
        this.lineLength = FastaWriter.checkLineLength(lineLength);
    }

    public FastaWriter(File outputFile, int lineLength) throws IOException {
        this.writer = FileUtils.createFastBufferedWriter((File)outputFile, (Charset)BioCharsets.FASTA_CHARSET);
        this.lineLength = FastaWriter.checkLineLength(lineLength);
    }

    public FastaWriter(String outputFilename, int lineLength) throws IOException {
        this.writer = FileUtils.createFastBufferedWriter((String)outputFilename, (Charset)BioCharsets.FASTA_CHARSET);
        this.lineLength = FastaWriter.checkLineLength(lineLength);
    }

    public FastaWriter(Writer writer) {
        this(writer, 60);
    }

    public FastaWriter(OutputStream os) throws FileNotFoundException {
        this(os, 60);
    }

    public FastaWriter(File outputFile) throws IOException {
        this(outputFile, 60);
    }

    public FastaWriter(String outputFilename) throws IOException {
        this(outputFilename, 60);
    }
}

