/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import fr.ens.biologie.genomique.kenetre.bio.io.ReadSequenceReader;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FastqReader
implements ReadSequenceReader {
    private final BufferedReader reader;
    private ReadSequence result = null;
    private final StringBuilder sb = new StringBuilder();
    private int lineCount = 0;
    private boolean end = false;
    private boolean nextCallDone = true;
    protected IOException ioException;
    protected BadBioEntryException bbeException;

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Iterator<ReadSequence> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.end) {
            return false;
        }
        this.nextCallDone = false;
        String line = null;
        int entryLine = 0;
        try {
            while ((line = this.reader.readLine()) != null) {
                ++this.lineCount;
                String trim = line.trim();
                this.sb.append(trim);
                if (++entryLine == 1 && trim.charAt(0) != '@') {
                    throw new BadBioEntryException("Invalid Fastq file. First line of the entry don't start with '@' at line " + this.lineCount, line);
                }
                if (entryLine == 3 && trim.charAt(0) != '+') {
                    throw new BadBioEntryException("Invalid Fastq file. Third line of the entry don't start with '+' at line " + this.lineCount, line);
                }
                if (entryLine == 4) {
                    this.result = new ReadSequence();
                    this.result.parseFastQ(this.sb.toString());
                    this.sb.setLength(0);
                    return true;
                }
                this.sb.append('\n');
            }
            this.sb.setLength(0);
            this.end = true;
            return false;
        }
        catch (IOException e) {
            this.ioException = e;
            this.end = true;
            return false;
        }
        catch (BadBioEntryException e) {
            this.bbeException = e;
            this.end = true;
            return false;
        }
    }

    @Override
    public ReadSequence next() {
        if (this.nextCallDone) {
            throw new NoSuchElementException();
        }
        this.nextCallDone = true;
        return this.result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void throwException() throws IOException, BadBioEntryException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (this.bbeException != null) {
            throw this.bbeException;
        }
    }

    public FastqReader(InputStream is) {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.reader = new BufferedReader(new InputStreamReader(is, BioCharsets.FASTQ_CHARSET));
    }

    public FastqReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.reader = FileUtils.createBufferedReader((File)file, (Charset)BioCharsets.FASTQ_CHARSET);
    }

    public FastqReader(String filename) throws FileNotFoundException {
        this.reader = FileUtils.createBufferedReader((String)filename, (Charset)BioCharsets.FASTQ_CHARSET);
    }
}

