/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.ReadSequenceWriter;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class FastqWriter
implements ReadSequenceWriter {
    private final Writer writer;

    @Override
    public void write(ReadSequence readSequence) throws IOException {
        if (readSequence != null) {
            this.writer.write(readSequence.toFastQ() + '\n');
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public FastqWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("The writer is null.");
        }
        this.writer = writer;
    }

    public FastqWriter(OutputStream os) throws FileNotFoundException {
        this.writer = FileUtils.createFastBufferedWriter((OutputStream)os);
    }

    public FastqWriter(File outputFile) throws IOException {
        this.writer = FileUtils.createFastBufferedWriter((File)outputFile);
    }

    public FastqWriter(String outputFilename) throws IOException {
        this.writer = FileUtils.createFastBufferedWriter((String)outputFilename);
    }
}

