/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.EntryMetadata;
import fr.ens.biologie.genomique.kenetre.bio.GFFEntry;
import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GFFReader
implements Iterator<GFFEntry>,
Iterable<GFFEntry>,
Closeable {
    private final BufferedReader reader;
    private GFFEntry result = null;
    private boolean end;
    private boolean fastaSectionFound;
    private final EntryMetadata metadata = new EntryMetadata();
    private boolean nextCallDone = true;
    protected IOException ioException;
    protected BadBioEntryException bbeException;
    private boolean gff3Format = true;

    @Override
    public Iterator<GFFEntry> iterator() {
        return this;
    }

    public boolean isFastaSectionFound() {
        return this.fastaSectionFound;
    }

    @Override
    public boolean hasNext() {
        if (this.end) {
            return false;
        }
        String line = null;
        try {
            while ((line = this.reader.readLine()) != null) {
                if (line.startsWith("###")) continue;
                if (line.startsWith("##FASTA")) {
                    this.fastaSectionFound = true;
                    this.end = true;
                    return false;
                }
                if (line.startsWith("##")) {
                    int posTab = line.indexOf(32);
                    if (posTab == -1) continue;
                    String mdKey = line.substring(2, posTab).trim();
                    String mdValue = line.substring(posTab + 1).trim();
                    this.metadata.add(mdKey, mdValue);
                    continue;
                }
                if (line.startsWith("#")) continue;
                this.result = new GFFEntry(this.metadata);
                if (this.gff3Format) {
                    this.result.parseGFF3(line.trim());
                } else {
                    this.result.parseGTF(line.trim());
                }
                this.nextCallDone = false;
                return true;
            }
        }
        catch (IOException e) {
            this.ioException = e;
        }
        catch (BadBioEntryException e) {
            this.bbeException = e;
        }
        this.end = true;
        return false;
    }

    @Override
    public GFFEntry next() {
        if (this.nextCallDone) {
            throw new NoSuchElementException();
        }
        this.nextCallDone = true;
        return this.result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void throwException() throws IOException, BadBioEntryException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (this.bbeException != null) {
            throw this.bbeException;
        }
    }

    protected boolean isGFF3Format() {
        return this.gff3Format;
    }

    protected void setGFF3Format(boolean gffFormat) {
        this.gff3Format = gffFormat;
    }

    public GFFReader(InputStream is) {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.reader = new BufferedReader(new InputStreamReader(is, BioCharsets.GFF_CHARSET));
    }

    public GFFReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.reader = FileUtils.createBufferedReader((File)file, (Charset)BioCharsets.GFF_CHARSET);
    }

    public GFFReader(String filename) throws FileNotFoundException {
        this.reader = FileUtils.createBufferedReader((String)filename, (Charset)BioCharsets.GFF_CHARSET);
    }
}

