/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.DenseExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.ExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.ExpressionMatrixReader;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

public class SparseExpressionMatrixReader
implements ExpressionMatrixReader {
    private final InputStream is;

    @Override
    public ExpressionMatrix read() throws IOException {
        return this.read(new DenseExpressionMatrix());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExpressionMatrix read(ExpressionMatrix matrix) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        boolean first = true;
        Splitter splitter = Splitter.on((char)'\t');
        int lineCount = 0;
        try (BufferedReader reader = FileUtils.createBufferedReader((InputStream)this.is);){
            String line;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                ++lineCount;
                if (line.isEmpty() || line.startsWith("#")) continue;
                if (first) {
                    if (!"gene\tcell\tcount".equals(line.trim().toLowerCase())) {
                        throw new IOException("Invalid header: " + line);
                    }
                    first = false;
                    continue;
                }
                List fields = GuavaCompatibility.splitToList((Splitter)splitter, (CharSequence)line);
                if (fields.size() != 3) {
                    throw new IOException("Invalid field count (" + fields.size() + ") at line " + lineCount + ", expected 3 fields: " + line);
                }
                try {
                    matrix.setValue((String)fields.get(0), (String)fields.get(1), Integer.parseInt((String)fields.get(2)));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Invalid count at line " + lineCount + ": " + line);
                    return matrix;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public SparseExpressionMatrixReader(InputStream is) {
        Objects.requireNonNull(is, "is argument cannot be null");
        this.is = is;
    }

    public SparseExpressionMatrixReader(File file) throws FileNotFoundException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.is = new FileInputStream(file);
    }

    public SparseExpressionMatrixReader(String filename) throws FileNotFoundException {
        Objects.requireNonNull(filename, "filename argument cannot be null");
        this.is = new FileInputStream(filename);
    }
}

