/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import fr.ens.biologie.genomique.kenetre.bio.io.ReadSequenceReader;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TFQReader
implements ReadSequenceReader {
    private final BufferedReader reader;
    private ReadSequence result = null;
    private boolean end = false;
    private boolean nextCallDone = true;
    protected IOException ioException;

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Iterator<ReadSequence> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.end) {
            return false;
        }
        this.nextCallDone = false;
        String line = null;
        try {
            while ((line = this.reader.readLine()) != null) {
                String trim = line.trim();
                if ("".equals(trim)) continue;
                this.result = new ReadSequence();
                this.result.parse(trim);
                return true;
            }
            this.end = true;
            return false;
        }
        catch (IOException e) {
            this.ioException = e;
            this.end = true;
            return false;
        }
    }

    @Override
    public ReadSequence next() {
        if (this.nextCallDone) {
            throw new NoSuchElementException();
        }
        this.nextCallDone = true;
        return this.result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void throwException() throws IOException, BadBioEntryException {
        if (this.ioException != null) {
            throw this.ioException;
        }
    }

    public TFQReader(InputStream is) {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.reader = FileUtils.createBufferedReader((InputStream)is, (Charset)BioCharsets.FASTQ_CHARSET);
    }

    public TFQReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.reader = FileUtils.createBufferedReader((File)file, (Charset)BioCharsets.FASTQ_CHARSET);
    }

    public TFQReader(String filename) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("File is null");
        }
        this.reader = FileUtils.createBufferedReader((String)filename, (Charset)BioCharsets.FASTQ_CHARSET);
    }
}

