/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.AnnotationMatrix;
import fr.ens.biologie.genomique.kenetre.bio.DenseAnnotationMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.AnnotationMatrixReader;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TSVAnnotationMatrixReader
implements AnnotationMatrixReader {
    private InputStream is;
    private static final String SEPARATOR = "\t";
    private boolean removeQuotes = true;

    public boolean isRemoveQuotes() {
        return this.removeQuotes;
    }

    @Override
    public AnnotationMatrix read() throws IOException {
        return this.read(new DenseAnnotationMatrix());
    }

    @Override
    public AnnotationMatrix read(AnnotationMatrix matrix) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        boolean first = true;
        Splitter splitter = Splitter.on((String)SEPARATOR);
        ArrayList columnNames = null;
        try (BufferedReader reader = FileUtils.createBufferedReader((InputStream)this.is);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                List fields = GuavaCompatibility.splitToList((Splitter)splitter, (CharSequence)line);
                if (first) {
                    if (fields.size() == 1) continue;
                    columnNames = new ArrayList(fields);
                    columnNames.remove(0);
                    first = false;
                    continue;
                }
                if (fields.size() > columnNames.size() + 1) {
                    throw new IOException("Found a line with invalid number of column: " + line);
                }
                Iterator it = columnNames.iterator();
                String rowName = null;
                for (String s : fields) {
                    if (rowName == null) {
                        rowName = s;
                        continue;
                    }
                    matrix.setValue(rowName, (String)it.next(), TSVAnnotationMatrixReader.removeDoubleQuotesAndTrim(s));
                }
            }
        }
        return matrix;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    private static String removeDoubleQuotes(String s) {
        if (s == null) {
            return null;
        }
        String result = s;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String removeDoubleQuotesAndTrim(String s) {
        if (s == null) {
            return null;
        }
        return TSVAnnotationMatrixReader.removeDoubleQuotes(s.trim());
    }

    public TSVAnnotationMatrixReader(String filename) throws IOException {
        this(new File(filename), false);
    }

    public TSVAnnotationMatrixReader(String filename, boolean noHeader) throws IOException {
        this(new File(filename), noHeader);
    }

    public TSVAnnotationMatrixReader(File file) throws IOException {
        this(file, false);
    }

    public TSVAnnotationMatrixReader(File file, boolean noHeader) throws IOException {
        if (file == null) {
            throw new IOException("No file to load");
        }
        this.is = new FileInputStream(file);
    }

    public TSVAnnotationMatrixReader(InputStream is) throws IOException {
        this(is, false);
    }

    public TSVAnnotationMatrixReader(InputStream is, boolean noHeader) throws IOException {
        this.is = is;
    }
}

