/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.io.CountsReader;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TSVCountsReader
implements CountsReader {
    private InputStream is;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, Integer> read() throws IOException {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        String line = null;
        int lineCount = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));){
            Splitter splitter = Splitter.on((char)'\t').trimResults();
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                ++lineCount;
                if (line.isEmpty() || line.startsWith("#")) continue;
                if (first) {
                    first = false;
                    continue;
                }
                List fields = GuavaCompatibility.splitToList((Splitter)splitter, (CharSequence)line);
                if (fields.size() != 2) {
                    throw new IOException("Invalid number of fields found line " + lineCount + ", 2 fields are expected: " + line);
                }
                try {
                    result.put((String)fields.get(0), Integer.parseInt((String)fields.get(1)));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Invalid count found line " + lineCount + ": " + line);
                    return result;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public TSVCountsReader(InputStream is) {
        Objects.requireNonNull(is, "InputStream is null");
        this.is = is;
    }

    public TSVCountsReader(File file) throws FileNotFoundException {
        Objects.requireNonNull(file, "file argument is null");
        this.is = new FileInputStream(file);
    }

    public TSVCountsReader(String filename) throws FileNotFoundException {
        Objects.requireNonNull(filename, "filename argument is null");
        this.is = new FileInputStream(filename);
    }
}

